/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class TypeJudgement {
    private IInputKey inputKey;
    private Tuple variablesTuple;

    public TypeJudgement(IInputKey inputKey, Tuple variablesTuple) {
        this.inputKey = inputKey;
        this.variablesTuple = variablesTuple;
    }

    public IInputKey getInputKey() {
        return this.inputKey;
    }

    public Tuple getVariablesTuple() {
        return this.variablesTuple;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputKey == null ? 0 : this.inputKey.hashCode());
        result = 31 * result + (this.variablesTuple == null ? 0 : this.variablesTuple.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeJudgement)) {
            return false;
        }
        TypeJudgement other = (TypeJudgement)obj;
        if (this.inputKey == null ? other.inputKey != null : !this.inputKey.equals(other.inputKey)) {
            return false;
        }
        return !(this.variablesTuple == null ? other.variablesTuple != null : !this.variablesTuple.equals(other.variablesTuple));
    }

    public Set<TypeJudgement> getDirectlyImpliedJudgements(IQueryMetaContext context) {
        HashSet<TypeJudgement> results = new HashSet<TypeJudgement>();
        results.add(this);
        Collection<InputKeyImplication> implications = context.getImplications(this.inputKey);
        for (InputKeyImplication inputKeyImplication : implications) {
            results.add(this.transcribeImplication(inputKeyImplication));
        }
        return results;
    }

    public Set<TypeJudgement> getWeakenedAlternativeJudgements(IQueryMetaContext context) {
        HashSet<TypeJudgement> results = new HashSet<TypeJudgement>();
        Collection<InputKeyImplication> implications = context.getWeakenedAlternatives(this.inputKey);
        for (InputKeyImplication inputKeyImplication : implications) {
            results.add(this.transcribeImplication(inputKeyImplication));
        }
        return results;
    }

    public Map<TypeJudgement, Set<TypeJudgement>> getConditionalImpliedJudgements(IQueryMetaContext context) {
        return context.getConditionalImplications(this.inputKey).entrySet().stream().collect(Collectors.toMap(entry -> this.transcribeImplication((InputKeyImplication)entry.getKey()), entry -> ((Set)entry.getValue()).stream().map(this::transcribeImplication).collect(Collectors.toSet())));
    }

    private TypeJudgement transcribeImplication(InputKeyImplication inputKeyImplication) {
        return new TypeJudgement(inputKeyImplication.getImpliedKey(), this.transcribeVariablesToTuple(inputKeyImplication.getImpliedIndices()));
    }

    private Tuple transcribeVariablesToTuple(List<Integer> indices) {
        Object[] elements = new Object[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            elements[i] = this.variablesTuple.get(indices.get(i));
            ++i;
        }
        return Tuples.flatTupleOf(elements);
    }

    public String toString() {
        return "TypeJudgement:" + this.inputKey.getPrettyPrintableName() + "@" + this.variablesTuple.toString();
    }

    public PConstraint createConstraintFor(PBody pBody) {
        if (this.inputKey.isEnumerable()) {
            return new TypeConstraint(pBody, this.variablesTuple, this.inputKey);
        }
        return new TypeFilterConstraint(pBody, this.variablesTuple, this.inputKey);
    }
}

