/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra.query.runtime.localsearch.operations.ExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchToolingActivator;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.IPlanNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationKind;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.PatternBodyNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationNode;

public class OperationListLabelProvider
extends StyledCellLabelProvider {
    private LocalResourceManager localResourceManager;
    private ImageRegistry imageRegistry = LocalSearchToolingActivator.getDefault().getImageRegistry();

    public void update(ViewerCell cell) {
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
        StyledString text = new StyledString();
        final IPlanNode node = (IPlanNode)cell.getElement();
        text.setStyle(0, text.length(), new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = OperationListLabelProvider.this.localResourceManager.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)1));
                OperationListLabelProvider.this.doColoring(node, textStyle);
            }
        });
        text.append(node.getLabelText());
        if (node instanceof PatternBodyNode) {
            text.append("Pattern Body");
        } else if (node instanceof SearchOperationNode) {
            cell.setImage(this.imageRegistry.get("applied_operation"));
        }
        switch (node.getOperationStatus()) {
            case EXECUTED: {
                break;
            }
            case CURRENT: {
                cell.setImage(this.imageRegistry.get("current_operation"));
                text.setStyle(0, text.length(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        LocalResourceManager localResMan = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
                        textStyle.font = localResMan.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)3));
                        OperationListLabelProvider.this.doColoring(node, textStyle);
                        textStyle.background = OperationListLabelProvider.this.localResourceManager.createColor(new RGB(200, 235, 255));
                    }
                });
                break;
            }
            case QUEUED: {
                cell.setImage(this.imageRegistry.get("not_applied_operation"));
                text.setStyle(0, text.length(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        LocalResourceManager localResMan = new LocalResourceManager(JFaceResources.getResources((Display)Display.getCurrent()));
                        textStyle.font = localResMan.createFont(FontDescriptor.createFrom((String)"Arial", (int)10, (int)0));
                        OperationListLabelProvider.this.doColoring(node, textStyle);
                    }
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation status: " + (Object)((Object)node.getOperationStatus()));
            }
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        super.update(cell);
    }

    private OperationKind calculateOperationKind(ISearchOperation searchOperation) {
        if (searchOperation instanceof ExtendOperationExecutor) {
            return OperationKind.EXTEND;
        }
        if (searchOperation instanceof NACOperation) {
            return OperationKind.NAC;
        }
        if (searchOperation instanceof CountOperation) {
            return OperationKind.COUNT;
        }
        return OperationKind.CHECK;
    }

    private void doColoring(IPlanNode node, TextStyle textStyle) {
        if (node instanceof SearchOperationNode) {
            this.doColoring(((SearchOperationNode)node).getSearchOperation(), textStyle);
        }
        if (node.isBreakpointSet()) {
            textStyle.borderStyle = 1;
            textStyle.borderColor = this.localResourceManager.createColor(new RGB(200, 0, 0));
        }
    }

    private void doColoring(ISearchOperation searchOperation, TextStyle textStyle) {
        switch (this.calculateOperationKind(searchOperation)) {
            case EXTEND: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(0, 200, 0));
                break;
            }
            case COUNT: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(200, 200, 200));
                break;
            }
            case NAC: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(230, 0, 0));
                break;
            }
            case CHECK: {
                textStyle.foreground = this.localResourceManager.createColor(new RGB(100, 100, 100));
            }
        }
    }

    public void dispose() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
        }
        super.dispose();
    }
}

