/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;

public class PDisjunctionRewriterCacher
extends PDisjunctionRewriter {
    private final List<PDisjunctionRewriter> rewriterChain;
    private WeakHashMap<PDisjunction, PDisjunction> cachedResults = new WeakHashMap();

    private void setupTraceCollectorInChain() {
        IRewriterTraceCollector collector = this.getTraceCollector();
        for (PDisjunctionRewriter rewriter : this.rewriterChain) {
            rewriter.setTraceCollector(collector);
        }
    }

    public PDisjunctionRewriterCacher(PDisjunctionRewriter rewriter) {
        this.rewriterChain = Collections.singletonList(rewriter);
    }

    public PDisjunctionRewriterCacher(PDisjunctionRewriter ... rewriters) {
        this.rewriterChain = new ArrayList<PDisjunctionRewriter>(Arrays.asList(rewriters));
    }

    public PDisjunctionRewriterCacher(List<PDisjunctionRewriter> rewriterChain) {
        this.rewriterChain = new ArrayList<PDisjunctionRewriter>(rewriterChain);
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) {
        if (!this.cachedResults.containsKey(disjunction)) {
            PDisjunction rewritten = disjunction;
            this.setupTraceCollectorInChain();
            for (PDisjunctionRewriter rewriter : this.rewriterChain) {
                rewritten = rewriter.rewrite(rewritten);
            }
            this.cachedResults.put(disjunction, rewritten);
        }
        return this.cachedResults.get(disjunction);
    }
}

