/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.diff;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.internal.StandardBundleManifest;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;

public class BundleDiffer {
    private static void diff(File bundle1, File bundle2) throws IOException {
        BundleManifest bundleManifest1 = BundleDiffer.createManifest(bundle1);
        BundleManifest bundleManifest2 = BundleDiffer.createManifest(bundle2);
        List importPackages1 = bundleManifest1.getImportPackage().getImportedPackages();
        List importPackages2 = bundleManifest2.getImportPackage().getImportedPackages();
        List exportPackages1 = bundleManifest1.getExportPackage().getExportedPackages();
        List exportPackages2 = bundleManifest2.getExportPackage().getExportedPackages();
        ArrayList<String> differences = new ArrayList<String>();
        BundleDiffer.compareImports(bundle1, importPackages1, bundle2, importPackages2, differences);
        BundleDiffer.compareExports(bundle1, exportPackages1, bundle2, exportPackages2, differences);
        if (!differences.isEmpty()) {
            System.out.println(bundle1 + " " + bundle2);
            for (String difference : differences) {
                System.out.println("    " + difference);
            }
        }
    }

    private static BundleManifest createManifest(File bundle) throws IOException {
        JarFile jarFile = new JarFile(bundle);
        ZipEntry manifest = jarFile.getEntry("META-INF/MANIFEST.MF");
        InputStreamReader in = new InputStreamReader(jarFile.getInputStream(manifest));
        try {
            StandardBundleManifest standardBundleManifest = new StandardBundleManifest((ParserLogger)new SimpleParserLogger(), (Reader)in);
            return standardBundleManifest;
        }
        finally {
            ((Reader)in).close();
        }
    }

    private static void process(File fileToProcess, String dir1Path, String dir2Path) throws IOException {
        if (fileToProcess.isDirectory()) {
            File[] files = fileToProcess.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    BundleDiffer.process(file, dir1Path, dir2Path);
                    ++n2;
                }
            }
        } else if (fileToProcess.getName().endsWith(".jar") && !fileToProcess.getName().contains("-sources-")) {
            File otherFile = new File(fileToProcess.getAbsolutePath().replace(dir1Path, dir2Path));
            if (otherFile.exists()) {
                BundleDiffer.diff(fileToProcess, otherFile);
            } else {
                System.out.println("File '" + otherFile + "' corresponding to file '" + fileToProcess + "' was not found.");
            }
        }
    }

    private static void compareImports(File file1, List<ImportedPackage> importsOne, File file2, List<ImportedPackage> importsTwo, List<String> differences) {
        for (ImportedPackage packageImport : importsOne) {
            if (BundleDiffer.findMatchingImport(packageImport.getPackageName(), importsTwo)) continue;
            differences.add(file2 + " does not import " + packageImport.getPackageName());
        }
        for (ImportedPackage packageImport : importsTwo) {
            if (BundleDiffer.findMatchingImport(packageImport.getPackageName(), importsOne)) continue;
            differences.add(file1 + " does not import " + packageImport.getPackageName());
        }
    }

    private static void compareExports(File file1, List<ExportedPackage> exportsOne, File file2, List<ExportedPackage> exportsTwo, List<String> differences) {
        for (ExportedPackage packageExport : exportsOne) {
            if (BundleDiffer.findMatchingExport(packageExport.getPackageName(), exportsTwo)) continue;
            differences.add(file2 + " does not export " + packageExport.getPackageName());
        }
        for (ExportedPackage packageExport : exportsTwo) {
            if (BundleDiffer.findMatchingExport(packageExport.getPackageName(), exportsOne)) continue;
            differences.add(file1 + " does not export " + packageExport.getPackageName());
        }
    }

    private static boolean findMatchingImport(String packageName, List<ImportedPackage> imports) {
        for (ImportedPackage packageImport : imports) {
            if (!packageImport.getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private static boolean findMatchingExport(String packageName, List<ExportedPackage> exports) {
        for (ExportedPackage packageExport : exports) {
            if (!packageExport.getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        String dir1Path = args[0];
        String dir2Path = args[1];
        File dir1 = new File(dir1Path);
        BundleDiffer.process(dir1, dir1Path, dir2Path);
    }

    private static class SimpleParserLogger
    implements ParserLogger {
        private volatile boolean used = false;
        private final List<String> messages = new ArrayList<String>();
        private final Object messagesMonitor = new Object();

        private SimpleParserLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] errorReports() {
            if (this.used) {
                Object object = this.messagesMonitor;
                synchronized (object) {
                    return this.messages.toArray(new String[this.messages.size()]);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void outputErrorMsg(Exception re, String item) {
            this.used = true;
            Object object = this.messagesMonitor;
            synchronized (object) {
                this.messages.add(item);
            }
            System.err.println(item);
            re.printStackTrace();
        }
    }
}

