/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.jdt.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;

public class ArtifactAnalyserTypeVisitor
extends ASTVisitor {
    private final PartialManifest partialManifest;
    private final Set<String> referencedTypes = new HashSet<String>();
    private String typePackage;

    public ArtifactAnalyserTypeVisitor(PartialManifest model) {
        this.partialManifest = model;
    }

    public boolean visit(CastExpression node) {
        this.recordTypeBinding(node.resolveTypeBinding());
        return true;
    }

    public boolean visit(CatchClause node) {
        this.recordTypeBinding(node.getException().getType().resolveBinding());
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        this.recordTypeBinding(node.resolveTypeBinding());
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        this.recordTypeBinding(node.getType().resolveBinding());
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (node.resolveBinding() != null && !node.resolveBinding().isRecovered()) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof IPackageBinding) {
                this.partialManifest.recordReferencedPackage(((IPackageBinding)binding).getName());
            } else if (binding instanceof ITypeBinding) {
                this.recordTypeBinding((ITypeBinding)binding);
            }
        } else if (!node.isOnDemand() && !node.isStatic()) {
            Name importElementName = node.getName();
            this.recordFullyQualifiedName(importElementName.getFullyQualifiedName());
        } else if (node.isOnDemand() && !node.isStatic()) {
            Name importElementName = node.getName();
            this.partialManifest.recordReferencedPackage(importElementName.getFullyQualifiedName());
        } else if (!node.isOnDemand() && node.isStatic()) {
            Name importElementName = node.getName();
            String fqn = importElementName.getFullyQualifiedName().substring(0, importElementName.getFullyQualifiedName().lastIndexOf(46));
            this.recordFullyQualifiedName(fqn);
        }
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        this.recordTypeBinding(node.getRightOperand().resolveBinding());
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        ITypeBinding binding = node.resolveTypeBinding();
        this.recordTypeBinding(binding);
        this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(binding).getName());
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        IPackageBinding packageBinding;
        int n;
        ITypeBinding[] iTypeBindingArray;
        String fqn;
        IMethodBinding binding = node.resolveBinding();
        if (binding == null) {
            return true;
        }
        if (binding.getReturnType() != null && !"void".equals(fqn = binding.getReturnType().getQualifiedName())) {
            IPackageBinding packageBinding2;
            this.recordTypeBinding(binding.getReturnType());
            if (!Modifier.isPrivate((int)node.getModifiers()) && (packageBinding2 = this.getPackageBinding(binding.getReturnType())) != null) {
                this.partialManifest.recordUsesPackage(this.typePackage, packageBinding2.getName());
            }
        }
        if (binding.getExceptionTypes() != null) {
            iTypeBindingArray = binding.getExceptionTypes();
            n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding exceptionBinding = iTypeBindingArray[n2];
                this.recordTypeBinding(exceptionBinding);
                if (!Modifier.isPrivate((int)node.getModifiers()) && (packageBinding = this.getPackageBinding(exceptionBinding)) != null) {
                    this.partialManifest.recordUsesPackage(this.typePackage, packageBinding.getName());
                }
                ++n2;
            }
        }
        if (binding.getParameterTypes() != null) {
            iTypeBindingArray = binding.getParameterTypes();
            n = iTypeBindingArray.length;
            int n3 = 0;
            while (n3 < n) {
                ITypeBinding parameterBinding = iTypeBindingArray[n3];
                this.recordTypeBinding(parameterBinding);
                if (!Modifier.isPrivate((int)node.getModifiers()) && (packageBinding = this.getPackageBinding(parameterBinding)) != null) {
                    this.partialManifest.recordUsesPackage(this.typePackage, packageBinding.getName());
                }
                ++n3;
            }
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            this.recordTypeBinding(binding.getDeclaringClass());
            if (binding.getReturnType() != null) {
                this.recordTypeBinding(binding.getReturnType());
            }
            if (binding.getParameterTypes() != null) {
                ITypeBinding[] iTypeBindingArray = binding.getParameterTypes();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding parameterBinding = iTypeBindingArray[n2];
                    this.recordTypeBinding(parameterBinding);
                    ++n2;
                }
            }
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        ITypeBinding binding = node.resolveTypeBinding();
        this.recordTypeBinding(binding);
        this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(binding).getName());
        return true;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (this.isValid(binding)) {
            this.recordTypeBinding(node.resolveTypeBinding());
            if (binding.getKind() == 3) {
                this.recordTypeBinding(((IVariableBinding)binding).getDeclaringClass());
            }
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        String fqn = node.getFullyQualifiedName();
        this.recordFullyQualifiedName(fqn);
        return true;
    }

    private boolean isValid(IBinding binding) {
        return binding != null && !binding.isRecovered();
    }

    public boolean visit(SimpleType node) {
        if (this.isValid((IBinding)node.resolveBinding())) {
            this.recordTypeBinding(node.resolveBinding());
        } else {
            Name simpleName = node.getName();
            String fqn = simpleName.getFullyQualifiedName();
            this.recordFullyQualifiedName(fqn);
        }
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        ITypeBinding binding = node.resolveTypeBinding();
        this.recordTypeBinding(binding);
        this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(binding).getName());
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return false;
        }
        String name = binding.getBinaryName();
        this.typePackage = this.getPackageBinding(binding).getName();
        if (!node.isLocalTypeDeclaration()) {
            this.partialManifest.recordType(name);
        }
        for (String referencedType : this.referencedTypes) {
            this.recordFullyQualifiedName(referencedType);
        }
        if (node.getSuperclassType() != null) {
            ITypeBinding superClassBinding = node.getSuperclassType().resolveBinding();
            this.recordTypeBinding(superClassBinding);
            this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(superClassBinding).getName());
        }
        int i = 0;
        while (i < node.superInterfaceTypes().size()) {
            Type interfaceType = (Type)node.superInterfaceTypes().get(i);
            ITypeBinding interfaceBinding = interfaceType.resolveBinding();
            this.recordTypeBinding(interfaceBinding);
            this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(interfaceBinding).getName());
            ++i;
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        ITypeBinding[] interfaceBindings;
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return false;
        }
        this.partialManifest.recordType(binding.getBinaryName());
        ITypeBinding superClassBinding = binding.getSuperclass();
        if (superClassBinding != null) {
            this.recordTypeBinding(superClassBinding);
            this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(superClassBinding).getName());
        }
        if ((interfaceBindings = binding.getInterfaces()) != null) {
            ITypeBinding[] iTypeBindingArray = interfaceBindings;
            int n = interfaceBindings.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding interfaceBinding = iTypeBindingArray[n2];
                this.recordTypeBinding(interfaceBinding);
                this.partialManifest.recordUsesPackage(this.typePackage, this.getPackageBinding(interfaceBinding).getName());
                ++n2;
            }
        }
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return false;
        }
        String name = binding.getBinaryName();
        this.typePackage = this.getPackageBinding(binding).getName();
        this.partialManifest.recordType(name);
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding == null) {
            return false;
        }
        String name = binding.getBinaryName();
        this.typePackage = this.getPackageBinding(binding).getName();
        this.partialManifest.recordType(name);
        return true;
    }

    private IPackageBinding getPackageBinding(ITypeBinding binding) {
        if (binding != null) {
            if (binding.isArray()) {
                return this.getPackageBinding(binding.getComponentType());
            }
            return binding.getPackage();
        }
        return null;
    }

    private String recordFullyQualifiedName(String fqn) {
        if (!"void".equals(fqn)) {
            if (this.typePackage == null) {
                this.referencedTypes.add(fqn);
                return fqn;
            }
            if (fqn != null && !this.typePackage.equals(this.getPackageName(fqn))) {
                StringTokenizer segments = new StringTokenizer(fqn, ".");
                if (segments.countTokens() > 1) {
                    ArrayList<String> newSegments = new ArrayList<String>();
                    while (segments.hasMoreTokens()) {
                        String segment = segments.nextToken();
                        newSegments.add(segment);
                        if (!Character.isLowerCase(segment.charAt(0))) break;
                    }
                    fqn = StringUtils.join(newSegments, (String)".");
                }
                this.partialManifest.recordReferencedType(fqn);
                return fqn;
            }
        }
        return "";
    }

    private String getPackageName(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName == null) {
            return "";
        }
        int index = fullyQualifiedTypeName.lastIndexOf(46);
        if (index > -1) {
            return fullyQualifiedTypeName.substring(0, index);
        }
        return "";
    }

    private String recordTypeBinding(ITypeBinding binding) {
        if (binding != null) {
            if (binding.isArray()) {
                return this.recordTypeBinding(binding.getComponentType());
            }
            String fqn = binding.getBinaryName();
            return this.recordFullyQualifiedName(fqn);
        }
        return "";
    }
}

