/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerRuntimeComposite;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiPlugin;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class VirgoServerRuntimeWizardFragment
extends WizardFragment {
    protected ServerRuntimeComposite comp;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate(null);
        return status == null || status.getSeverity() != 4;
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        String wizardTitle = ServerUiPlugin.getResourceString("virgoWizardTitle");
        String wizardDescription = ServerUiPlugin.getResourceString("virgoWizardDescription");
        this.comp = new ServerRuntimeComposite(parent, wizard, wizardTitle, wizardDescription, ServerUiImages.DESC_WIZB_VIRGO_SERVER);
        return this.comp;
    }

    public void enter() {
        if (this.comp != null) {
            IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
            this.comp.setRuntime(runtime);
        }
    }

    public void exit() {
        IRuntimeWorkingCopy runtime = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        IPath path = runtime.getLocation();
        if (runtime.validate(null).getSeverity() != 4) {
            ServerCorePlugin.setPreference((String)("location" + runtime.getRuntimeType().getId()), (String)path.toString());
        }
    }
}

