/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core;

import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.virgo.bundlor.ClassPath;
import org.eclipse.virgo.bundlor.ClassPathEntry;
import org.eclipse.virgo.bundlor.EntryScannerListener;
import org.eclipse.virgo.bundlor.ManifestGenerator;
import org.eclipse.virgo.bundlor.support.classpath.StandardClassPathFactory;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.support.properties.FileSystemPropertiesSource;
import org.eclipse.virgo.bundlor.support.properties.PropertiesSource;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.bundlor.util.SimpleManifestContents;
import org.eclipse.virgo.ide.bundlor.internal.core.BundlorCorePlugin;
import org.eclipse.virgo.ide.bundlor.internal.core.IncrementalPartialManifestManager;
import org.eclipse.virgo.ide.bundlor.internal.core.ManifestGeneratorFactory;
import org.eclipse.virgo.ide.bundlor.internal.core.asm.ExtensibleAsmTypeArtefactAnalyser;
import org.eclipse.virgo.ide.bundlor.jdt.core.AstTypeArtifactAnalyser;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.editor.model.SpringBundleModel;
import org.eclipse.virgo.ide.manifest.core.editor.model.SpringBundleModelFactory;
import org.eclipse.virgo.ide.module.core.ServerModuleDelegate;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;
import org.eclipse.virgo.util.parser.manifest.RecoveringManifestParser;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlorProjectBuilder
extends IncrementalProjectBuilder {
    private static final String WEB_XML_PATH = "WEB-INF/web.xml";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Set<IResource> deletedSourceResources = new HashSet<IResource>();
    private final Set<IResource> deletedTestResources = new HashSet<IResource>();
    private final Set<IResource> sourceResources = new HashSet<IResource>();
    private final Set<IResource> testResources = new HashSet<IResource>();
    private boolean forceFullBuild = false;
    private boolean scanByteCode = true;
    private final List<ImportedPackage> templatePackageImports = new ArrayList<ImportedPackage>();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.deletedSourceResources.clear();
        this.sourceResources.clear();
        this.deletedTestResources.clear();
        this.testResources.clear();
        this.templatePackageImports.clear();
        this.forceFullBuild = false;
        IProject project = this.getProject();
        IResourceDelta delta = this.getDelta(project);
        this.scanByteCode = this.getProjectPreferences(project).getBoolean("byte.code.scanning", true);
        this.visitResourceDelta(project, kind, delta);
        this.build(kind, monitor);
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (file != null && file.exists()) {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    private void addResourceIfInSourceFolder(IResource resource, Set<IClasspathEntry> classpathEntries, Set<IClasspathEntry> testClasspathEntries) {
        for (IClasspathEntry entry : classpathEntries) {
            if (!entry.getPath().isPrefixOf(resource.getFullPath())) continue;
            this.sourceResources.add(resource);
            return;
        }
        for (IClasspathEntry entry : testClasspathEntries) {
            if (!entry.getPath().isPrefixOf(resource.getFullPath())) continue;
            this.testResources.add(resource);
            return;
        }
    }

    private void build(int kind, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject;
        IncrementalPartialManifestManager manifestManager;
        monitor.beginTask("Scanning source code to generate MANIFEST.MF", this.sourceResources.size() + this.testResources.size());
        if (this.sourceResources.size() == 0 && this.testResources.size() == 0 && this.deletedSourceResources.size() == 0 && this.deletedTestResources.size() == 0 && !this.forceFullBuild) {
            return;
        }
        if (this.forceFullBuild) {
            kind = 6;
        }
        boolean isFullBuild = !(manifestManager = BundlorCorePlugin.getDefault().getManifestManager()).hasPartialManifest(javaProject = JavaCore.create((IProject)this.getProject())) || kind == 6;
        ReadablePartialManifest model = manifestManager.getPartialManifest(javaProject, false, isFullBuild);
        ReadablePartialManifest testModel = manifestManager.getPartialManifest(javaProject, true, isFullBuild);
        PropertiesSource[] propertiesSources = this.createPropertiesSource(javaProject);
        Object artefactAnalyser = this.scanByteCode ? new ProgressReportingAsmTypeArtefactAnalyser(monitor) : new ProgressReportingAstTypeArtefactAnalyser(javaProject, monitor);
        try {
            BundleManifest manifest = this.generateManifest(javaProject, model, ManifestGeneratorFactory.create(model, artefactAnalyser, propertiesSources), this.sourceResources, isFullBuild, false);
            BundleManifest testManifest = this.generateManifest(javaProject, testModel, ManifestGeneratorFactory.create(testModel, artefactAnalyser, propertiesSources), this.testResources, isFullBuild, true);
            this.mergeManifests(javaProject, manifest, testManifest);
            monitor.done();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.virgo.ide.bundlor.core", "Exception while generating manifest.", (Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private PropertiesSource[] createPropertiesSource(IJavaProject javaProject) throws CoreException {
        IProject project = javaProject.getProject();
        IEclipsePreferences preferences = this.getProjectPreferences(project);
        String propertiesFiles = preferences.get("template.properties.files", "template.properties;build.properties");
        String[] properties = StringUtils.split((String)propertiesFiles, (String)";");
        ArrayList<Object> paths = new ArrayList<Object>();
        if (properties != null && properties.length > 0) {
            void var8_11;
            String[] stringArray = properties;
            int n = properties.length;
            boolean n2 = false;
            while (var8_11 < n) {
                String propertiesFile = stringArray[var8_11];
                Path location = new Path(propertiesFile);
                IFile propertiesResource = project.getFile((IPath)location);
                if (propertiesResource.exists()) {
                    if (propertiesResource.isLinked()) {
                        paths.add(propertiesResource.getLocation());
                    } else {
                        paths.add(propertiesResource.getRawLocation());
                    }
                } else {
                    IPath projectRelativeLocation = project.getLocation();
                    if (projectRelativeLocation == null) {
                        projectRelativeLocation = project.getRawLocation();
                    }
                    if ((projectRelativeLocation = location.append(propertiesFile)).toFile().exists()) {
                        paths.add(projectRelativeLocation);
                    } else {
                        IPath workspaceRelativeLocation = project.getWorkspace().getRoot().getLocation().append((IPath)location);
                        if (workspaceRelativeLocation.toFile().exists()) {
                            paths.add(workspaceRelativeLocation);
                        } else if (location.toFile().exists()) {
                            paths.add(location);
                        }
                    }
                }
                ++var8_11;
            }
        }
        HashSet<FileSystemPropertiesSource> propertiesSources = new HashSet<FileSystemPropertiesSource>();
        for (IPath iPath : paths) {
            propertiesSources.add(new FileSystemPropertiesSource(iPath.toFile()));
        }
        return propertiesSources.toArray(new PropertiesSource[0]);
    }

    private ManifestContents createManifestFromPath(IResource templateResource) throws IOException {
        if (templateResource != null) {
            RecoveringManifestParser parser = new RecoveringManifestParser();
            ManifestContents manifest = null;
            manifest = parser.parse((Reader)new FileReader(templateResource.getRawLocation().toString()));
            return manifest;
        }
        return new SimpleManifestContents();
    }

    private void doGetAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        IJavaProject project = JavaCore.create((IProject)this.getProject());
        if (project == null) {
            return;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        Set classpathEntries = ServerModuleDelegate.getSourceClasspathEntries((IProject)resource.getProject(), (boolean)false);
        Set testClasspathEntries = ServerModuleDelegate.getSourceClasspathEntries((IProject)resource.getProject(), (boolean)true);
        if (!this.scanByteCode && resource.getName().endsWith("java")) {
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element != null && element.getJavaProject().isOnClasspath(element)) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                try {
                    IClasspathEntry classpathEntry = root.getRawClasspathEntry();
                    for (IClasspathEntry entry : classpathEntries) {
                        if (!classpathEntry.equals(entry)) continue;
                        if (deltaKind == 2) {
                            this.deletedSourceResources.add(resource);
                            break;
                        }
                        this.sourceResources.add(resource);
                        break;
                    }
                    for (IClasspathEntry entry : testClasspathEntries) {
                        if (!classpathEntry.equals(entry)) continue;
                        if (deltaKind == 2) {
                            this.deletedTestResources.add(resource);
                        } else {
                            this.testResources.add(resource);
                        }
                        break;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        } else if (this.scanByteCode && resource.getName().endsWith(CLASS_FILE_EXTENSION)) {
            IPath outputLocation;
            IPath classFilePath = resource.getFullPath();
            IPath defaultOutputLocation = project.getOutputLocation();
            if (defaultOutputLocation.isPrefixOf(classFilePath)) {
                String className = classFilePath.removeFirstSegments(defaultOutputLocation.segmentCount()).toString();
                int ix = (className = className.substring(0, className.length() - CLASS_FILE_EXTENSION.length())).indexOf(36);
                if (ix > 0) {
                    className = className.substring(0, ix);
                }
                className = String.valueOf(className) + ".java";
                if (deltaKind == 2) {
                    this.deletedSourceResources.add(resource);
                    this.deletedTestResources.add(resource);
                } else {
                    IResource sourceFolder;
                    IPath sourceLocation;
                    for (IClasspathEntry entry : classpathEntries) {
                        sourceLocation = entry.getPath();
                        sourceFolder = wsRoot.findMember(sourceLocation);
                        if (!(sourceFolder instanceof IFolder) || ((IFolder)sourceFolder).findMember(className) == null) continue;
                        this.sourceResources.add(resource);
                        break;
                    }
                    for (IClasspathEntry entry : testClasspathEntries) {
                        sourceLocation = entry.getPath();
                        sourceFolder = wsRoot.findMember(sourceLocation);
                        if (!(sourceFolder instanceof IFolder) || ((IFolder)sourceFolder).findMember(className) == null) continue;
                        this.testResources.add(resource);
                        break;
                    }
                }
            }
            for (IClasspathEntry entry : classpathEntries) {
                outputLocation = entry.getOutputLocation();
                if (outputLocation == null || !outputLocation.isPrefixOf(classFilePath)) continue;
                if (deltaKind == 2) {
                    this.deletedSourceResources.add(resource);
                    break;
                }
                this.sourceResources.add(resource);
                break;
            }
            for (IClasspathEntry entry : testClasspathEntries) {
                outputLocation = entry.getOutputLocation();
                if (outputLocation == null || !outputLocation.isPrefixOf(classFilePath)) continue;
                if (deltaKind == 2) {
                    this.deletedTestResources.add(resource);
                } else {
                    this.testResources.add(resource);
                }
                break;
            }
        } else if (resource.getName().equals("template.mf") || resource.getName().equals("MANIFEST.MF")) {
            this.forceFullBuild = true;
        } else if (resource.getName().endsWith(".hbm")) {
            this.addResourceIfInSourceFolder(resource, classpathEntries, testClasspathEntries);
        } else if (resource.getName().equals("persistence.xml") && resource.getParent() != null && resource.getParent().getName().equals("META-INF")) {
            this.addResourceIfInSourceFolder(resource, classpathEntries, testClasspathEntries);
        } else if (this.isWebXML(resource)) {
            this.sourceResources.add(resource);
        } else if (resource.getName().endsWith(".xml")) {
            this.addResourceIfInSourceFolder(resource, classpathEntries, testClasspathEntries);
        }
    }

    private boolean isWebXML(IResource resource) {
        return resource.getFullPath().toString().endsWith(WEB_XML_PATH) && FacetUtils.hasProjectFacet((IResource)resource, (String)"jst.web");
    }

    private BundleManifest generateManifest(IJavaProject javaProject, ReadablePartialManifest model, ManifestGenerator generator, Set<IResource> resources, boolean isFullBuild, boolean isTestManifest) throws JavaModelException, CoreException, IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Set<String> folders = this.getSourceFolders(javaProject, root, isTestManifest);
        for (IResource deletedResource : isTestManifest ? this.deletedTestResources : this.deletedSourceResources) {
            String path = deletedResource.getRawLocation().toString();
            for (String folder : folders) {
                if (!path.startsWith(folder)) continue;
                path = path.substring(folder.length() + 1);
                if (model instanceof EntryScannerListener) {
                    ((EntryScannerListener)model).onBeginEntry(path);
                }
                ((EntryScannerListener)model).onEndEntry();
            }
        }
        IResource templateResource = this.getProject().findMember("template.mf");
        ManifestContents templateManifest = this.createManifestFromPath(templateResource);
        if (isTestManifest) {
            templateManifest.getMainAttributes().remove("Import-Package");
            templateManifest.getMainAttributes().remove("Import-Bundle");
            templateManifest.getMainAttributes().remove("Import-Library");
            if (templateManifest.getMainAttributes().containsKey("Test-Import-Bundle")) {
                templateManifest.getMainAttributes().put("Import-Bundle", (String)templateManifest.getMainAttributes().get("Test-Import-Bundle"));
            }
            if (templateManifest.getMainAttributes().containsKey("Test-Import-Package")) {
                templateManifest.getMainAttributes().put("Import-Package", (String)templateManifest.getMainAttributes().get("Test-Import-Package"));
            }
            if (templateManifest.getMainAttributes().containsKey("Test-Import-Library")) {
                templateManifest.getMainAttributes().put("Import-Library", (String)templateManifest.getMainAttributes().get("Test-Import-Library"));
            }
        } else {
            String importPackageHeader = (String)templateManifest.getMainAttributes().get("Import-Package");
            Hashtable<String, String> contents = new Hashtable<String, String>();
            if (importPackageHeader != null) {
                ((Dictionary)contents).put("Import-Package", importPackageHeader);
            }
            this.templatePackageImports.addAll(BundleManifestFactory.createBundleManifest(contents).getImportPackage().getImportedPackages());
        }
        ManifestContents manifest = null;
        ArrayList<ClassPath> classpathEntries = new ArrayList<ClassPath>();
        StandardClassPathFactory factory = new StandardClassPathFactory();
        if (isFullBuild) {
            for (String folder : folders) {
                classpathEntries.add(factory.create(folder));
            }
        } else {
            for (String folder : folders) {
                classpathEntries.add(new FilteringClassPath(resources, folder));
            }
        }
        manifest = generator.generate(templateManifest, classpathEntries.toArray(new ClassPath[classpathEntries.size()]));
        return BundleManifestUtils.createBundleManifest((ManifestContents)manifest);
    }

    private Set<String> getSourceFolders(IJavaProject javaProject, IWorkspaceRoot root, boolean testFolders) throws JavaModelException {
        IResource resource;
        IResource sourceFolder;
        HashSet<String> folders = new HashSet<String>();
        for (IClasspathEntry entry : ServerModuleDelegate.getSourceClasspathEntries((IProject)this.getProject(), (boolean)testFolders)) {
            IResource classFolder;
            IResource sourceFolder2 = root.findMember(entry.getPath());
            if (sourceFolder2 instanceof IFolder && !(sourceFolder2 instanceof IWorkspaceRoot)) {
                folders.add(((IFolder)sourceFolder2).getRawLocation().toString());
            }
            if (!this.scanByteCode || entry.getOutputLocation() == null || !((classFolder = root.findMember(entry.getOutputLocation())) instanceof IFolder) || classFolder instanceof IWorkspaceRoot) continue;
            folders.add(((IFolder)classFolder).getRawLocation().toString());
        }
        if (this.scanByteCode && (sourceFolder = root.findMember(javaProject.getOutputLocation())) instanceof IFolder && !(sourceFolder instanceof IWorkspaceRoot)) {
            folders.add(((IFolder)sourceFolder).getRawLocation().toString());
        }
        if (!testFolders && FacetUtils.hasProjectFacet((IResource)this.getProject(), (String)"jst.web") && (resource = this.getProject().findMember(WEB_XML_PATH)) != null) {
            folders.add(resource.getRawLocation().removeLastSegments(2).toString());
        }
        return folders;
    }

    private void mergeManifests(IJavaProject javaProject, BundleManifest manifest, BundleManifest testManifest) throws CoreException {
        IStatus valid;
        StringWriter writer;
        IFile testManifestResource;
        if (manifest == null) {
            return;
        }
        BundleManifest cleanTestManifest = null;
        if (testManifest != null) {
            cleanTestManifest = BundleManifestFactory.createBundleManifest();
            cleanTestManifest.setBundleManifestVersion(2);
            if (testManifest.getImportBundle() != null && testManifest.getImportBundle().getImportedBundles() != null && testManifest.getImportBundle().getImportedBundles().size() > 0) {
                cleanTestManifest.getImportBundle().getImportedBundles().addAll(testManifest.getImportBundle().getImportedBundles());
            }
            if (testManifest.getImportLibrary() != null && testManifest.getImportLibrary().getImportedLibraries() != null && testManifest.getImportLibrary().getImportedLibraries().size() > 0) {
                cleanTestManifest.getImportLibrary().getImportedLibraries().addAll(testManifest.getImportLibrary().getImportedLibraries());
            }
            for (ImportedPackage packageImport : testManifest.getImportPackage().getImportedPackages()) {
                boolean notImported = true;
                for (ImportedPackage manifestPackageImport : manifest.getImportPackage().getImportedPackages()) {
                    if (!manifestPackageImport.getPackageName().equals(packageImport.getPackageName())) continue;
                    notImported = false;
                    break;
                }
                if (!notImported) continue;
                boolean skip = false;
                for (ExportedPackage packageExport : manifest.getExportPackage().getExportedPackages()) {
                    String packageImportName = packageImport.getPackageName();
                    if (!packageExport.getPackageName().equals(packageImportName)) continue;
                    skip = true;
                }
                if (skip) continue;
                cleanTestManifest.getImportPackage().getImportedPackages().add(packageImport);
            }
        }
        ArrayList importedPackagesCopy = new ArrayList(manifest.getImportPackage().getImportedPackages());
        block7: for (ExportedPackage packageExport : manifest.getExportPackage().getExportedPackages()) {
            for (ImportedPackage packageImport : importedPackagesCopy) {
                if (!packageExport.getPackageName().equals(packageImport.getPackageName())) continue;
                boolean remove = true;
                for (ImportedPackage templatePackageImport : this.templatePackageImports) {
                    if (!packageExport.getPackageName().equals(templatePackageImport.getPackageName())) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                manifest.getImportPackage().getImportedPackages().remove(packageImport);
                continue block7;
            }
        }
        IFile manifestResource = org.eclipse.virgo.ide.manifest.core.BundleManifestUtils.locateManifest((IJavaProject)javaProject, (boolean)false);
        if (manifestResource == null) {
            manifestResource = org.eclipse.virgo.ide.manifest.core.BundleManifestUtils.getFirstPossibleManifestFile((IProject)this.getProject(), (boolean)false);
        }
        if ((testManifestResource = org.eclipse.virgo.ide.manifest.core.BundleManifestUtils.locateManifest((IJavaProject)javaProject, (boolean)true)) == null) {
            testManifestResource = org.eclipse.virgo.ide.manifest.core.BundleManifestUtils.getFirstPossibleManifestFile((IProject)this.getProject(), (boolean)true);
        }
        boolean formatPref = this.getProjectPreferences(javaProject.getProject()).getBoolean("bundlor.generated.manifest.autoformatting", false);
        if (manifestResource != null && manifestResource instanceof IFile) {
            try {
                writer = new StringWriter();
                manifest.write((Writer)writer);
                InputStream manifestStream = new ByteArrayInputStream(writer.toString().getBytes());
                if (formatPref) {
                    manifestStream = this.formatManifest(manifestResource, manifestStream);
                }
                if ((valid = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{manifestResource}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                    manifestResource.setContents(manifestStream, 3, (IProgressMonitor)new NullProgressMonitor());
                }
                writer.close();
                manifestStream.close();
            }
            catch (IOException iOException) {}
        }
        if (testManifestResource != null && testManifestResource instanceof IFile) {
            try {
                writer = new StringWriter();
                cleanTestManifest.write((Writer)writer);
                InputStream testManifestStream = new ByteArrayInputStream(writer.toString().getBytes());
                if (formatPref) {
                    testManifestStream = this.formatManifest(testManifestResource, testManifestStream);
                }
                if ((valid = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{testManifestResource}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                    testManifestResource.setContents(testManifestStream, 3, (IProgressMonitor)new NullProgressMonitor());
                }
                writer.close();
                testManifestStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private InputStream formatManifest(IFile file, InputStream manifestInput) throws IOException {
        StringWriter writer = new StringWriter();
        SpringBundleModel model = new SpringBundleModel("", true);
        SpringBundleModelFactory factory = new SpringBundleModelFactory((IBundleModel)model);
        try {
            Map headers = ManifestElement.parseBundleManifest((InputStream)manifestInput, null);
            for (Object obj : headers.keySet()) {
                String key = (String)obj;
                String value = (String)headers.get(key);
                ManifestHeader header = (ManifestHeader)factory.createHeader(key, value);
                header.update(false);
                String result = header.write();
                writer.write(result);
            }
        }
        catch (BundleException bundleException) {}
        String manifestOutput = writer.toString();
        writer.close();
        manifestInput.close();
        model.dispose();
        return new ByteArrayInputStream(manifestOutput.getBytes());
    }

    private void visitResourceDelta(IProject project, final int kind, IResourceDelta delta) throws CoreException {
        if (delta == null || kind == 6) {
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    BundlorProjectBuilder.this.doGetAffectedResources(resource, 6, 4);
                    return true;
                }
            };
            project.accept(visitor);
        } else {
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    BundlorProjectBuilder.this.doGetAffectedResources(delta.getResource(), kind, delta.getKind());
                    return true;
                }
            };
            delta.accept(visitor);
        }
    }

    public IEclipsePreferences getProjectPreferences(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.virgo.ide.bundlor.core");
        return node;
    }

    class FileClassPathEntry
    implements ClassPathEntry {
        private final String name;
        private final IFile file;

        public FileClassPathEntry(String name, IFile file) {
            this.name = name;
            this.file = file;
        }

        public InputStream getInputStream() {
            try {
                return this.file.getContents(true);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public Reader getReader() {
            return new InputStreamReader(this.getInputStream());
        }

        public boolean isDirectory() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilteringClassPath
    implements ClassPath {
        private final Map<String, ClassPathEntry> entries = new HashMap<String, ClassPathEntry>();

        public FilteringClassPath(Set<IResource> resources, String folder) {
            for (IResource resource : resources) {
                String path;
                if (!(resource instanceof IFile) || !(path = resource.getRawLocation().toString()).startsWith(folder)) continue;
                path = path.substring(folder.length() + 1);
                this.entries.put(path, new FileClassPathEntry(path, (IFile)resource));
            }
        }

        public void close() {
        }

        public ClassPathEntry getEntry(String name) {
            return this.entries.get(name);
        }

        public Iterator<ClassPathEntry> iterator() {
            return this.entries.values().iterator();
        }
    }

    class ProgressReportingAsmTypeArtefactAnalyser
    extends ExtensibleAsmTypeArtefactAnalyser {
        private final IProgressMonitor monitor;

        public ProgressReportingAsmTypeArtefactAnalyser(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void analyse(InputStream is, String name, PartialManifest model) throws Exception {
            this.monitor.subTask("Scanning '" + name + "'");
            super.analyse(is, name, model);
            this.monitor.worked(1);
        }
    }

    class ProgressReportingAstTypeArtefactAnalyser
    extends AstTypeArtifactAnalyser {
        private final IProgressMonitor monitor;

        public ProgressReportingAstTypeArtefactAnalyser(IJavaProject javaProject, IProgressMonitor monitor) {
            super(javaProject);
            this.monitor = monitor;
        }

        public void analyse(InputStream is, String name, PartialManifest model) throws Exception {
            this.monitor.subTask("Scanning '" + name + "'");
            super.analyse(is, name, model);
            this.monitor.worked(1);
        }
    }
}

