/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.facet.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.par.ParPackage;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class FacetUtils {
    public static boolean isBundleProject(IResource resource) {
        return FacetUtils.hasNature(resource, "org.eclipse.jdt.core.javanature") && FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.bundle");
    }

    public static boolean isParProject(IResource resource) {
        return FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.par");
    }

    public static boolean isPlanProject(IResource resource) {
        return FacetUtils.hasProjectFacet(resource, "org.eclipse.virgo.server.plan");
    }

    public static boolean hasProjectFacet(IResource resource, String facetId) {
        if (resource != null && resource.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)resource.getProject(), (String)facetId);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.facet.core", "An error occurred inspecting project facet", (Throwable)e));
            }
        }
        return false;
    }

    public static boolean hasNature(IResource resource, String natureId) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature(natureId);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.facet.core", "An error occurred inspecting project nature", (Throwable)e));
            }
        }
        return false;
    }

    public static IProject[] getBundleProjects() {
        IProject[] projects;
        ArrayList<IProject> bundles = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject candidate = iProjectArray[n2];
            if (FacetUtils.isBundleProject((IResource)candidate)) {
                bundles.add(candidate);
            }
            ++n2;
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static IProject[] getParProjects(IProject project) {
        IProject[] projects;
        HashSet<IProject> bundles = new HashSet<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject candidate = iProjectArray[n2];
            if (FacetUtils.isParProject((IResource)candidate) && Arrays.asList(FacetUtils.getBundleProjects(candidate)).contains(project)) {
                bundles.add(candidate);
            }
            ++n2;
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static IProject[] getBundleProjects(IProject parProject) {
        Par par;
        HashSet<IProject> bundles = new HashSet<IProject>();
        if (FacetUtils.isParProject((IResource)parProject) && (par = FacetUtils.getParDefinition(parProject)) != null && par.getBundle() != null) {
            for (Bundle bundle : par.getBundle()) {
                IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
                if (!FacetUtils.isBundleProject((IResource)bundleProject)) continue;
                bundles.add(bundleProject);
            }
        }
        return bundles.toArray(new IProject[bundles.size()]);
    }

    public static Par getParDefinition(IProject project) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://eclipse.org/virgo/par.ecore", (Object)ParPackage.eINSTANCE);
        File parFile = new File(new File(String.valueOf(project.getLocation().toString()) + File.separatorChar + ".settings"), "org.eclipse.virgo.ide.runtime.core.par.xml");
        if (parFile.exists()) {
            Resource resource;
            block7: {
                URI fileUri = URI.createFileURI((String)parFile.toString());
                resource = null;
                try {
                    resource = resourceSet.getResource(fileUri, true);
                }
                catch (WrappedException e) {
                    if (!(e.getCause() instanceof PackageNotFoundException)) break block7;
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(parFile));
                        StringBuilder sb = new StringBuilder();
                        String next = br.readLine();
                        do {
                            next = next.replaceAll("http:///com/springsource/server/ide/par.ecore", "http://eclipse.org/virgo/par.ecore");
                            next = next.replaceAll("com\\.springsource\\.server", "org.eclipse.virgo");
                            sb.append(String.valueOf(next) + "\n");
                        } while ((next = br.readLine()) != null);
                        br.close();
                        BufferedWriter bw = new BufferedWriter(new FileWriter(parFile));
                        bw.write(sb.toString());
                        bw.close();
                        project.refreshLocal(2, null);
                        resource = resourceSet.getResource(fileUri, true);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (CoreException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            return (Par)resource.getContents().iterator().next();
        }
        return null;
    }

    public static IFile getParFile(IProject project) {
        IResource resource = project.findMember(new Path(".settings").append("org.eclipse.virgo.ide.runtime.core.par.xml"));
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }
}

