/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAdminServiceTracker
implements ServiceListener {
    private BundleContext _context;
    private List<BundleActivator> _activatedFragments = new ArrayList<BundleActivator>();
    private boolean _fragmentsWereActivated = false;
    public static PackageAdminServiceTracker INSTANCE = null;

    public PackageAdminServiceTracker(BundleContext context) {
        INSTANCE = this;
        this._context = context;
        if (!this.setup()) {
            try {
                this._context.addServiceListener((ServiceListener)this, "(objectclass=" + PackageAdmin.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setup() {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        boolean bl = this._fragmentsWereActivated = sr != null;
        if (sr != null) {
            this.invokeFragmentActivators(sr);
        }
        return this._fragmentsWereActivated;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.invokeFragmentActivators(event.getServiceReference());
        }
    }

    public Bundle[] getFragments(Bundle bundle) {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        if (sr == null) {
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        return admin.getFragments(bundle);
    }

    public Bundle[] getFragmentsAndRequiredBundles(Bundle bundle) {
        ServiceReference sr = this._context.getServiceReference(PackageAdmin.class.getName());
        if (sr == null) {
            return null;
        }
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        Bundle[] fragments = admin.getFragments(bundle);
        List<Bundle> requiredBundles = this.getRequiredBundles(bundle, admin);
        if (fragments != null) {
            HashSet<String> already = new HashSet<String>();
            for (Bundle b : requiredBundles) {
                already.add(b.getSymbolicName());
            }
            for (Bundle f : fragments) {
                List<Bundle> requiredBundlesByFragment = this.getRequiredBundles(f, admin);
                for (Bundle b : requiredBundlesByFragment) {
                    if (!already.add(b.getSymbolicName())) continue;
                    requiredBundles.add(b);
                }
            }
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>((fragments != null ? fragments.length : 0) + (requiredBundles != null ? requiredBundles.size() : 0));
        if (fragments != null) {
            for (Bundle f : fragments) {
                bundles.add(f);
            }
        }
        if (requiredBundles != null) {
            bundles.addAll(requiredBundles);
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    protected List<Bundle> getRequiredBundles(Bundle bundle, PackageAdmin admin) {
        ArrayList<Bundle> res = new ArrayList<Bundle>();
        String requiredBundleHeader = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundleHeader == null) {
            return res;
        }
        StringTokenizer tokenizer = new StringTokenizer(requiredBundleHeader, ",");
        block0: while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken().trim();
            StringTokenizer tokenizer2 = new StringTokenizer(tok, ";");
            String symbolicName = tokenizer2.nextToken().trim();
            String versionRange = null;
            while (tokenizer2.hasMoreTokens()) {
                String next = tokenizer2.nextToken().trim();
                if (!next.startsWith("bundle-version=")) continue;
                if (next.startsWith("bundle-version=\"") || next.startsWith("bundle-version='")) {
                    versionRange = next.substring("bundle-version=\"".length(), next.length() - 1);
                    continue;
                }
                versionRange = next.substring("bundle-version=".length());
            }
            Bundle[] reqBundles = admin.getBundles(symbolicName, versionRange);
            if (reqBundles == null) continue;
            for (Bundle b : reqBundles) {
                if (b.getState() != 32 && b.getState() != 8) continue;
                res.add(b);
                continue block0;
            }
        }
        return res;
    }

    private void invokeFragmentActivators(ServiceReference sr) {
        PackageAdmin admin = (PackageAdmin)this._context.getService(sr);
        Bundle[] fragments = admin.getFragments(this._context.getBundle());
        if (fragments == null) {
            return;
        }
        for (Bundle frag : fragments) {
            try {
                String fragmentActivator = frag.getSymbolicName() + ".FragmentActivator";
                Class<?> c = Class.forName(fragmentActivator);
                if (c == null) continue;
                BundleActivator bActivator = (BundleActivator)c.newInstance();
                bActivator.start(this._context);
                this._activatedFragments.add(bActivator);
            }
            catch (NullPointerException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        INSTANCE = null;
        for (BundleActivator fragAct : this._activatedFragments) {
            try {
                fragAct.stop(this._context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

