/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.util.ArrayList;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.ScpCommand;

public class ScpCommandFactory
implements CommandFactory {
    private CommandFactory delegate;

    public ScpCommandFactory() {
    }

    public ScpCommandFactory(CommandFactory delegate) {
        this.delegate = delegate;
    }

    public Command createCommand(String command) {
        try {
            return new ScpCommand(this.splitCommandString(command));
        }
        catch (IllegalArgumentException iae) {
            if (this.delegate != null) {
                return this.delegate.createCommand(command);
            }
            throw iae;
        }
    }

    private String[] splitCommandString(String command) {
        if (!command.trim().startsWith("scp")) {
            throw new IllegalArgumentException("Unknown command, does not begin with 'scp'");
        }
        String[] args = command.split(" ");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(args[0]);
        for (int i = 1; i < args.length; ++i) {
            if (!args[i].trim().startsWith("-")) {
                parts.add(this.concatenateWithSpace(args, i));
                break;
            }
            parts.add(args[i]);
        }
        return parts.toArray(new String[parts.size()]);
    }

    private String concatenateWithSpace(String[] args, int from) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < args.length; ++i) {
            sb.append(args[i] + " ");
        }
        return sb.toString().trim();
    }
}

