/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.completers;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.shell.CommandCompleter;
import org.eclipse.virgo.medic.log.EntryExitTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractInstallArtifactCompleter
implements CommandCompleter {
    private static final String SUBCOMMAND_LIST = "list";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String type;
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public AbstractInstallArtifactCompleter(String type, RuntimeArtifactModelObjectNameCreator objectNameCreator) {
        this.type = type;
        this.objectNameCreator = objectNameCreator;
    }

    @Override
    public final List<String> getCompletionCandidates(String subcommand, String ... tokens) {
        Set<String> candidates = SUBCOMMAND_LIST.equals(subcommand) ? Collections.emptySet() : (tokens.length == 2 ? this.versions(tokens[0], tokens[1]) : (tokens.length == 1 ? this.names(tokens[0]) : Collections.emptySet()));
        this.filter(candidates, subcommand, tokens);
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    protected void filter(Set<String> candidates, String subcommand, String ... tokens) {
        try {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Set<String> versions(String name, String version) {
        try {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            HashSet<String> candidates = new HashSet<String>();
            Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactVersionsQuery(this.type, name), null);
            for (ObjectName objectName : objectNames) {
                String candidateVersion = this.objectNameCreator.getVersion(objectName);
                if (!candidateVersion.startsWith(version)) continue;
                candidates.add(candidateVersion);
            }
            HashSet<String> hashSet = candidates;
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return hashSet;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private Set<String> names(String name) {
        try {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            HashSet<String> candidates = new HashSet<String>();
            Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactsOfTypeQuery(this.type), null);
            for (ObjectName objectName : objectNames) {
                String candidateName = this.objectNameCreator.getName(objectName);
                if (!candidateName.startsWith(name)) continue;
                candidates.add(candidateName);
            }
            HashSet<String> hashSet = candidates;
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return hashSet;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("AbstractInstallArtifactCompleter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("84", "filter", "org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter", "java.util.Set:java.lang.String:[Ljava.lang.String;:", "candidates:subcommand:tokens:", "", "void"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "versions", "org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.Set"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "names", "org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter", "java.lang.String:", "name:", "", "java.util.Set"), 86);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.completers.AbstractInstallArtifactCompleter");
    }
}

