/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.util;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public abstract class BundleUtils {
    public static final String DM_CORE_ID = "spring.osgi.core.bundle.id";
    public static final String DM_CORE_TS = "spring.osgi.core.bundle.timestamp";

    public static Bundle getDMCoreBundle(BundleContext ctx) {
        PackageAdmin pa;
        Object service;
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        if (ref != null && (service = ctx.getService(ref)) instanceof PackageAdmin && (pa = (PackageAdmin)service) != null) {
            return pa.getBundle(OsgiBundleXmlApplicationContext.class);
        }
        return null;
    }

    public static String createNamespaceFilter(BundleContext ctx) {
        Bundle bnd = BundleUtils.getDMCoreBundle(ctx);
        if (bnd != null) {
            return "(|(spring.osgi.core.bundle.id=" + bnd.getBundleId() + ")(" + DM_CORE_TS + "=" + bnd.getLastModified() + "))";
        }
        return "";
    }
}

