/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;

public class ServletInvocableHandlerMethod
extends InvocableHandlerMethod {
    private HttpStatus responseStatus;
    private String responseReason;
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;

    public void setHandlerMethodReturnValueHandlers(HandlerMethodReturnValueHandlerComposite returnValueHandlers) {
        this.returnValueHandlers = returnValueHandlers;
    }

    public ServletInvocableHandlerMethod(Object handler, Method method) {
        super(handler, method);
        ResponseStatus annotation = (ResponseStatus)this.getMethodAnnotation(ResponseStatus.class);
        if (annotation != null) {
            this.responseStatus = annotation.value();
            this.responseReason = annotation.reason();
        }
    }

    public final void invokeAndHandle(NativeWebRequest request, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object returnValue = this.invokeForRequest(request, mavContainer, providedArgs);
        this.setResponseStatus((ServletWebRequest)request);
        if (returnValue == null && (this.isRequestNotModified(request) || this.hasResponseStatus() || mavContainer.isRequestHandled())) {
            mavContainer.setRequestHandled(true);
            return;
        }
        mavContainer.setRequestHandled(false);
        try {
            this.returnValueHandlers.handleReturnValue(returnValue, this.getReturnType(), mavContainer, request);
        }
        catch (Exception ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.getReturnValueHandlingErrorMessage("Error handling return value", returnValue), (Throwable)ex);
            }
            throw ex;
        }
    }

    private String getReturnValueHandlingErrorMessage(String message, Object returnValue) {
        StringBuilder sb = new StringBuilder(message);
        if (returnValue != null) {
            sb.append(" [type=" + returnValue.getClass().getName() + "] ");
        }
        sb.append("[value=" + returnValue + "]");
        return this.getDetailedErrorMessage(sb.toString());
    }

    private void setResponseStatus(ServletWebRequest webRequest) throws IOException {
        if (this.responseStatus != null) {
            if (StringUtils.hasText((String)this.responseReason)) {
                webRequest.getResponse().sendError(this.responseStatus.value(), this.responseReason);
            } else {
                webRequest.getResponse().setStatus(this.responseStatus.value());
            }
            webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)this.responseStatus);
        }
    }

    private boolean isRequestNotModified(NativeWebRequest request) {
        return ((ServletWebRequest)request).isNotModified();
    }

    private boolean hasResponseStatus() {
        return this.responseStatus != null;
    }
}

