/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassEnhancer {
    private static final Log logger = LogFactory.getLog(ConfigurationClassEnhancer.class);
    private final List<Callback> callbackInstances = new ArrayList<Callback>();
    private final List<Class<? extends Callback>> callbackTypes = new ArrayList<Class<? extends Callback>>();
    private final CallbackFilter callbackFilter;

    public ConfigurationClassEnhancer(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.callbackInstances.add((Callback)new BeanMethodInterceptor(beanFactory));
        this.callbackInstances.add((Callback)new DisposableBeanMethodInterceptor());
        this.callbackInstances.add((Callback)NoOp.INSTANCE);
        for (Callback callback : this.callbackInstances) {
            this.callbackTypes.add(callback.getClass());
        }
        this.callbackFilter = new CallbackFilter(){

            public int accept(Method candidateMethod) {
                if (BeanAnnotationHelper.isBeanAnnotated(candidateMethod)) {
                    return 0;
                }
                if (DisposableBeanMethodInterceptor.isDestroyMethod(candidateMethod)) {
                    return 1;
                }
                return 2;
            }
        };
    }

    public Class<?> enhance(Class<?> configClass) {
        if (EnhancedConfiguration.class.isAssignableFrom(configClass)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Ignoring request to enhance %s as it has already been enhanced. This usually indicates that more than one ConfigurationClassPostProcessor has been registered (e.g. via <context:annotation-config>). This is harmless, but you may want check your configuration and remove one CCPP if possible", configClass.getName()));
            }
            return configClass;
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Successfully enhanced %s; enhanced class name is: %s", configClass.getName(), enhancedClass.getName()));
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> superclass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setUseCache(false);
        enhancer.setSuperclass(superclass);
        enhancer.setInterfaces(new Class[]{EnhancedConfiguration.class});
        enhancer.setUseFactory(false);
        enhancer.setCallbackFilter(this.callbackFilter);
        enhancer.setCallbackTypes(this.callbackTypes.toArray(new Class[this.callbackTypes.size()]));
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)subclass, (Callback[])this.callbackInstances.toArray(new Callback[this.callbackInstances.size()]));
        return subclass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanMethodInterceptor
    implements MethodInterceptor {
        private final ConfigurableBeanFactory beanFactory;

        public BeanMethodInterceptor(ConfigurableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Object intercept(Object enhancedConfigInstance, Method beanMethod, Object[] beanMethodArgs, MethodProxy cglibMethodProxy) throws Throwable {
            Object factoryBean;
            String scopedBeanName;
            String beanName = BeanAnnotationHelper.determineBeanNameFor(beanMethod);
            Scope scope = (Scope)AnnotationUtils.findAnnotation((Method)beanMethod, Scope.class);
            if (scope != null && scope.proxyMode() != ScopedProxyMode.NO && this.beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyCreator.getTargetBeanName(beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean(String.valueOf('&') + beanName) && this.factoryContainsBean(beanName) && !((factoryBean = this.beanFactory.getBean(String.valueOf('&') + beanName)) instanceof ScopedProxyFactoryBean)) {
                return this.enhanceFactoryBean(factoryBean.getClass(), beanName);
            }
            boolean factoryIsCaller = beanMethod.equals(SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod());
            boolean factoryAlreadyContainsSingleton = this.beanFactory.containsSingleton(beanName);
            if (factoryIsCaller && !factoryAlreadyContainsSingleton) {
                if (BeanFactoryPostProcessor.class.isAssignableFrom(beanMethod.getReturnType())) {
                    logger.warn((Object)String.format("@Bean method %s.%s is non-static and returns an object assignable to Spring's BeanFactoryPostProcessor interface. This will result in a failure to process annotations such as @Autowired, @Resource and @PostConstruct within the method's declaring @Configuration class. Add the 'static' modifier to this method to avoid these container lifecycle issues; see @Bean Javadoc for complete details", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName()));
                }
                return cglibMethodProxy.invokeSuper(enhancedConfigInstance, beanMethodArgs);
            }
            boolean alreadyInCreation = this.beanFactory.isCurrentlyInCreation(beanName);
            try {
                if (alreadyInCreation) {
                    this.beanFactory.setCurrentlyInCreation(beanName, false);
                }
                Object object = this.beanFactory.getBean(beanName);
                return object;
            }
            finally {
                if (alreadyInCreation) {
                    this.beanFactory.setCurrentlyInCreation(beanName, true);
                }
            }
        }

        private boolean factoryContainsBean(String beanName) {
            boolean containsBean = this.beanFactory.containsBean(beanName);
            boolean currentlyInCreation = this.beanFactory.isCurrentlyInCreation(beanName);
            return containsBean && !currentlyInCreation;
        }

        private Object enhanceFactoryBean(Class<?> fbClass, String beanName) throws InstantiationException, IllegalAccessException {
            Enhancer enhancer = new Enhancer();
            enhancer.setUseCache(false);
            enhancer.setSuperclass(fbClass);
            enhancer.setUseFactory(false);
            enhancer.setCallbackFilter(new CallbackFilter(){

                public int accept(Method method) {
                    return method.getName().equals("getObject") ? 0 : 1;
                }
            });
            ArrayList<GetObjectMethodInterceptor> callbackInstances = new ArrayList<GetObjectMethodInterceptor>();
            callbackInstances.add(new GetObjectMethodInterceptor(this.beanFactory, beanName));
            callbackInstances.add((GetObjectMethodInterceptor)NoOp.INSTANCE);
            ArrayList callbackTypes = new ArrayList();
            for (Callback callback : callbackInstances) {
                callbackTypes.add(callback.getClass());
            }
            enhancer.setCallbackTypes(callbackTypes.toArray(new Class[callbackTypes.size()]));
            Class clazz = enhancer.createClass();
            Enhancer.registerCallbacks((Class)clazz, (Callback[])callbackInstances.toArray(new Callback[callbackInstances.size()]));
            return clazz.newInstance();
        }
    }

    private static class DisposableBeanMethodInterceptor
    implements MethodInterceptor {
        private DisposableBeanMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Enhancer.registerStaticCallbacks(obj.getClass(), null);
            if (DisposableBean.class.isAssignableFrom(obj.getClass().getSuperclass())) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }

        public static boolean isDestroyMethod(Method candidateMethod) {
            return candidateMethod.getName().equals("destroy") && candidateMethod.getParameterTypes().length == 0 && DisposableBean.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }
    }

    public static interface EnhancedConfiguration
    extends DisposableBean {
    }

    private static class GetObjectMethodInterceptor
    implements MethodInterceptor {
        private final ConfigurableBeanFactory beanFactory;
        private final String beanName;

        public GetObjectMethodInterceptor(ConfigurableBeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.beanName = beanName;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            return this.beanFactory.getBean(this.beanName);
        }
    }
}

