/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.security.Permission;
import java.util.Dictionary;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.EventDispatcher;
import org.eclipse.equinox.internal.cm.ManagedServiceFactoryTracker;
import org.eclipse.equinox.internal.cm.ManagedServiceTracker;
import org.eclipse.equinox.internal.cm.PluginManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.log.LogService;

public class ConfigurationAdminFactory
implements ServiceFactory,
BundleListener {
    private final Permission configurationPermission = new ConfigurationPermission("*", "configure");
    private final EventDispatcher eventDispatcher;
    private final PluginManager pluginManager;
    private final LogService log;
    private final ManagedServiceTracker managedServiceTracker;
    private final ManagedServiceFactoryTracker managedServiceFactoryTracker;
    private final ConfigurationStore configurationStore;

    public ConfigurationAdminFactory(BundleContext context, LogService log) {
        this.log = log;
        this.configurationStore = new ConfigurationStore(this, context);
        this.eventDispatcher = new EventDispatcher(context, log);
        this.pluginManager = new PluginManager(context);
        this.managedServiceTracker = new ManagedServiceTracker(this, this.configurationStore, context);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this, this.configurationStore, context);
    }

    void start() {
        this.eventDispatcher.start();
        this.pluginManager.start();
        this.managedServiceTracker.open();
        this.managedServiceFactoryTracker.open();
    }

    void stop() {
        this.managedServiceTracker.close();
        this.managedServiceFactoryTracker.close();
        this.eventDispatcher.stop();
        this.pluginManager.stop();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        ServiceReference reference = registration.getReference();
        this.eventDispatcher.setServiceReference(reference);
        return new ConfigurationAdminImpl(this, this.configurationStore, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.configurationStore.unbindConfigurations(event.getBundle());
        }
    }

    public void checkConfigurationPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.configurationPermission);
        }
    }

    void log(int level, String message) {
        this.log.log(level, message);
    }

    void log(int level, String message, Throwable exception) {
        this.log.log(level, message, exception);
    }

    void dispatchEvent(int type, String factoryPid, String pid) {
        this.eventDispatcher.dispatchEvent(type, factoryPid, pid);
    }

    void notifyConfigurationUpdated(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyUpdated(config);
        } else {
            this.managedServiceTracker.notifyUpdated(config);
        }
    }

    void notifyConfigurationDeleted(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyDeleted(config);
        } else {
            this.managedServiceTracker.notifyDeleted(config);
        }
    }

    void modifyConfiguration(ServiceReference reference, Dictionary properties) {
        this.pluginManager.modifyConfiguration(reference, properties);
    }
}

