/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class annoType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        Map attributes = importingClassMetadata.getAnnotationAttributes(annoType.getName());
        Assert.notNull((Object)attributes, (String)String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        String modeAttrName = this.getAdviceModeAttributeName();
        Assert.hasText((String)modeAttrName);
        Object adviceMode = attributes.get(modeAttrName);
        Assert.notNull(adviceMode, (String)String.format("Advice mode attribute @%s#%s() does not exist", annoType.getSimpleName(), modeAttrName));
        Assert.isInstanceOf(AdviceMode.class, adviceMode, (String)String.format("Incorrect type for advice mode attribute '@%s#%s()': ", annoType.getSimpleName(), modeAttrName));
        String[] imports = this.selectImports((AdviceMode)((Object)adviceMode));
        Assert.notNull((Object)imports, (String)String.format("Unknown AdviceMode: '%s'", adviceMode));
        return imports;
    }

    protected abstract String[] selectImports(AdviceMode var1);
}

