/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console.internal;

import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.osgi.internal.signedcontent.Base64;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class AdminHttpContext
implements HttpContext {
    private static final String REALM = "Virgo Admin Console";
    private final Bundle bundle;

    public AdminHttpContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            return this.reject(request, response);
        }
        StringTokenizer tokens = new StringTokenizer(auth);
        String authscheme = tokens.nextToken();
        if (!authscheme.equals("Basic")) {
            return this.reject(request, response);
        }
        String base64credentials = tokens.nextToken();
        String credentials = new String(Base64.decode((byte[])base64credentials.getBytes()));
        int colon = credentials.indexOf(58);
        String userid = credentials.substring(0, colon);
        String password = credentials.substring(colon + 1);
        try {
            Subject subject = this.login(request.getSession(true), userid, password);
            if (subject == null) {
                return this.reject(request, response);
            }
            request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)userid);
            request.setAttribute("org.osgi.service.http.authentication.type", (Object)authscheme);
            request.setAttribute("org.osgi.service.useradmin.authorization", (Object)subject);
            return true;
        }
        catch (LoginException loginException) {
            return this.reject(request, response);
        }
    }

    public URL getResource(String name) {
        return this.bundle.getEntry(name);
    }

    public String getMimeType(String name) {
        return null;
    }

    private Subject login(HttpSession session, String userid, String password) throws LoginException {
        if (session == null) {
            return null;
        }
        LoginContext context = (LoginContext)session.getValue("securitycontext");
        if (context != null) {
            return context.getSubject();
        }
        context = new LoginContext("virgo-kernel", (CallbackHandler)new /* Unavailable Anonymous Inner Class!! */);
        context.login();
        Subject result = context.getSubject();
        if (result == null) {
            return null;
        }
        session.putValue("securitycontext", (Object)context);
        return result;
    }

    private boolean reject(HttpServletRequest request, HttpServletResponse response) {
        request.getSession(true);
        response.setHeader("WWW-Authenticate", "Basic realm=\"Virgo Admin Console\"");
        try {
            response.sendError(401);
        }
        catch (IOException iOException) {}
        return false;
    }
}

