/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.codec.RepositoryCodec;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RepositoryDumpContributor
implements DumpContributor {
    private static final Logger LOGGER;
    private static final String CONTRIBUTOR_NAME = "repository";
    private final Map<String, ArtifactDescriptorDepository> depositories = new ConcurrentHashMap<String, ArtifactDescriptorDepository>();
    private final RepositoryCodec codec;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.RepositoryDumpContributor");
        LOGGER = LoggerFactory.getLogger(RepositoryDumpContributor.class);
    }

    public RepositoryDumpContributor(RepositoryCodec codec) {
        this.codec = codec;
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        for (Map.Entry<String, ArtifactDescriptorDepository> entry : this.depositories.entrySet()) {
            this.dumpDepository(entry.getKey(), entry.getValue(), dump);
        }
    }

    public String getName() {
        return CONTRIBUTOR_NAME;
    }

    private void dumpDepository(String name, ArtifactDescriptorDepository depository, Dump dump) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    stream = dump.createFileOutputStream("repository-" + name + ".index");
                    Set<RepositoryAwareArtifactDescriptor> descriptors = depository.resolveArtifactDescriptors(null);
                    this.codec.write(descriptors, stream);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to dump repository index for repository '" + name + "'", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    void addDepository(String name, ArtifactDescriptorDepository depository) {
        this.depositories.put(name, depository);
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

