/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.annotations;

import java.util.ArrayList;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.osgi.annotations.AnnotationParser;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;

public class AnnotationConfiguration
extends org.eclipse.jetty.annotations.AnnotationConfiguration {
    protected org.eclipse.jetty.annotations.AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    public void parseWebInfLib(WebAppContext context, org.eclipse.jetty.annotations.AnnotationParser parser) throws Exception {
        AnnotationParser oparser = (AnnotationParser)parser;
        Bundle webbundle = (Bundle)context.getAttribute("osgi-bundle");
        Bundle[] fragAndRequiredBundles = PackageAdminServiceTracker.INSTANCE.getFragmentsAndRequiredBundles(webbundle);
        if (fragAndRequiredBundles != null) {
            for (Bundle bundle : fragAndRequiredBundles) {
                Resource bundleRes = oparser.indexBundle(bundle);
                if (context.getMetaData().getWebInfJars().contains(bundleRes)) continue;
                context.getMetaData().addWebInfJar(bundleRes);
            }
            for (Bundle fragmentBundle : fragAndRequiredBundles) {
                if (fragmentBundle.getHeaders().get("Fragment-Host") == null) continue;
                this.parseFragmentBundle(context, oparser, webbundle, fragmentBundle);
            }
        }
        this.parseWebBundle(context, oparser, webbundle);
        super.parseWebInfLib(context, parser);
        if (fragAndRequiredBundles != null) {
            for (Bundle requiredBundle : fragAndRequiredBundles) {
                if (requiredBundle.getHeaders().get("Fragment-Host") != null) continue;
                this.parseRequiredBundle(context, oparser, webbundle, requiredBundle);
            }
        }
    }

    protected void parseFragmentBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle fragmentBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, fragmentBundle);
    }

    protected void parseWebBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle) throws Exception {
        this.parseBundle(context, parser, webbundle, webbundle);
    }

    protected void parseRequiredBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle requiredBundle) throws Exception {
        this.parseBundle(context, parser, webbundle, requiredBundle);
    }

    protected void parseBundle(WebAppContext context, AnnotationParser parser, Bundle webbundle, Bundle bundle) throws Exception {
        Resource bundleRes = parser.getResource(bundle);
        parser.parse(bundle, this.createClassNameResolver(context));
        ArrayList annotations = new ArrayList();
        this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
        if (webbundle == bundle) {
            context.getMetaData().addDiscoveredAnnotations(annotations);
        } else {
            context.getMetaData().addDiscoveredAnnotations(bundleRes, annotations);
        }
    }

    protected ClassNameResolver createClassNameResolver(WebAppContext context) {
        return this.createClassNameResolver(context, true, false, false, false);
    }

    protected ClassNameResolver createClassNameResolver(final WebAppContext context, final boolean excludeSysClass, final boolean excludeServerClass, final boolean excludeEverythingElse, final boolean overrideIsParenLoaderIsPriority) {
        return new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return excludeSysClass;
                }
                if (context.isServerClass(name)) {
                    return excludeServerClass;
                }
                return excludeEverythingElse;
            }

            public boolean shouldOverride(String name) {
                if (context.isParentLoaderPriority()) {
                    return overrideIsParenLoaderIsPriority;
                }
                return !overrideIsParenLoaderIsPriority;
            }
        };
    }
}

