/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.managed.PassivationStrategy;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimplePassivater
implements PassivationStrategy {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private File sessionDirectory;

    public SimplePassivater() throws SystemException {
        this.init(null);
    }

    @Override
    public void init(Properties props) throws SystemException {
        if (props == null) {
            props = new Properties();
        }
        String dir = props.getProperty("org/openejb/core/InstanceManager/PASSIVATOR_PATH_PREFIX");
        try {
            this.sessionDirectory = dir != null ? SystemInstance.get().getBase().getDirectory(dir).getAbsoluteFile() : new File(System.getProperty("java.io.tmpdir", File.separator + "tmp")).getAbsoluteFile();
            if (!this.sessionDirectory.exists() && !this.sessionDirectory.mkdirs()) {
                throw new IOException("Failed to create directory: " + this.sessionDirectory.getAbsolutePath());
            }
            logger.info("Using directory " + this.sessionDirectory + " for stateful session passivation");
        }
        catch (IOException e) {
            throw new SystemException(this.getClass().getName() + ".init(): can't use directory prefix " + dir + ":" + e, e);
        }
    }

    public void passivate(Object primaryKey, Object state) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (!sessionFile.exists() && !sessionFile.createNewFile()) {
                throw new Exception("Failed to create passivation file: " + sessionFile.getAbsolutePath());
            }
            logger.info("Passivating to file " + sessionFile);
            ObjectOutputStream oos = new ObjectOutputStream(IO.write((File)sessionFile));
            oos.writeObject(state);
            oos.close();
            sessionFile.deleteOnExit();
        }
        catch (NotSerializableException nse) {
            logger.error("Passivation failed ", nse);
            throw (SystemException)new SystemException("The type " + nse.getMessage() + " is not serializable as mandated by the EJB specification.").initCause(nse);
        }
        catch (Exception t) {
            logger.error("Passivation failed ", t);
            throw new SystemException(t);
        }
    }

    @Override
    public void passivate(Map hash) throws SystemException {
        for (Object id : hash.keySet()) {
            this.passivate(id, hash.get(id));
        }
    }

    @Override
    public Object activate(Object primaryKey) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (sessionFile.exists()) {
                logger.info("Activating from file " + sessionFile);
                ObjectInputStream ois = new ObjectInputStream(IO.read((File)sessionFile));
                Object state = ois.readObject();
                ois.close();
                if (!sessionFile.delete()) {
                    sessionFile.deleteOnExit();
                }
                return state;
            }
            logger.info("Activation failed: file not found " + sessionFile);
            return null;
        }
        catch (Exception t) {
            logger.info("Activation failed ", t);
            throw new SystemException(t);
        }
    }
}

