/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.virgo.snaps.core.internal.SnapHostDefinition;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;

public final class SnapUtils {
    public static final String HEADER_SNAP_HOST = "Snap-Host";
    public static final String HEADER_SNAP_CONTEXT_PATH = "Snap-ContextPath";
    private static final String PATH_ELEMENT_SEPARATOR = "/";

    private SnapUtils() {
    }

    public static String determineSnapContextPath(HttpServletRequest request) {
        String includeServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String result = includeServletPath != null ? includeServletPath : request.getServletPath();
        int index = result.indexOf(PATH_ELEMENT_SEPARATOR, 1);
        if (index > -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    public static boolean hasSnapHostHeader(BundleManifest manifest) {
        return manifest.getHeader(HEADER_SNAP_HOST) != null;
    }

    public static Set<SnapHostDefinition> getSnapHostHeader(BundleManifest manifest) {
        String header = manifest.getHeader(HEADER_SNAP_HOST);
        return header == null ? null : SnapHostDefinition.parse(header);
    }

    public static String getSnapContextPath(Bundle bundle) {
        String contextPath = (String)bundle.getHeaders().get(HEADER_SNAP_CONTEXT_PATH);
        if (contextPath == null) {
            contextPath = SnapUtils.generateDefaultContextPath(bundle);
        }
        return contextPath;
    }

    public static String boundContextPath(String hostContextPath, String snapContextPath) {
        if (hostContextPath == null) {
            return snapContextPath == null ? "" : snapContextPath;
        }
        if (snapContextPath == null) {
            return hostContextPath;
        }
        if (hostContextPath.endsWith(PATH_ELEMENT_SEPARATOR)) {
            return String.valueOf(hostContextPath.substring(0, hostContextPath.length() - 1)) + snapContextPath;
        }
        return String.valueOf(hostContextPath) + snapContextPath;
    }

    private static String generateDefaultContextPath(Bundle bundle) {
        return SnapUtils.getBaseName(bundle.getLocation());
    }

    static String getBaseName(String path) {
        String base = path;
        if (base.endsWith(PATH_ELEMENT_SEPARATOR)) {
            base = base.substring(0, base.length() - 1);
        }
        base = SnapUtils.stripScheme(base);
        base = SnapUtils.stripQuery(base);
        base = SnapUtils.stripLeadingPathElements(base);
        base = SnapUtils.stripExtension(base);
        return base;
    }

    private static String stripExtension(String base) {
        int index = base.lastIndexOf(".");
        if (index > -1) {
            base = base.substring(0, index);
        }
        return base;
    }

    private static String stripLeadingPathElements(String base) {
        int index = base.lastIndexOf(PATH_ELEMENT_SEPARATOR);
        if (index > -1) {
            base = base.substring(index + 1);
        }
        return base;
    }

    private static String stripQuery(String path) {
        String result = path;
        int index = result.lastIndexOf("?");
        if (index > -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    private static String stripScheme(String path) {
        String result = path;
        int index = result.indexOf(":");
        if (index > -1 && index < result.length()) {
            result = result.substring(index + 1);
        }
        return result;
    }
}

