/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.detector;

import java.util.Dictionary;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.osgi.servlet.JolokiaServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractOsgiServerDetector
extends AbstractServerDetector {
    protected String getSystemBundleVersion() {
        Dictionary headers = this.getSystemBundleHeaders();
        return (String)headers.get("Bundle-Version");
    }

    protected String getBundleVersion(String pSymbolicName) {
        BundleContext context = JolokiaServlet.getCurrentBundleContext();
        if (context != null) {
            for (Bundle bundle : context.getBundles()) {
                if (!pSymbolicName.equalsIgnoreCase(bundle.getSymbolicName())) continue;
                Dictionary headers = bundle.getHeaders();
                return (String)headers.get("Bundle-Version");
            }
        }
        return null;
    }

    protected boolean checkSystemBundleForSymbolicName(String pSymbolicName) {
        Dictionary headers = this.getSystemBundleHeaders();
        if (headers != null) {
            String name = (String)headers.get("Bundle-SymbolicName");
            return name.startsWith(pSymbolicName);
        }
        return false;
    }

    private Dictionary getSystemBundleHeaders() {
        BundleContext context = JolokiaServlet.getCurrentBundleContext();
        if (context != null) {
            Bundle systemBundle = context.getBundle(0L);
            return systemBundle.getHeaders();
        }
        return null;
    }
}

