/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.recovery;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.nano.deployer.api.core.FatalDeploymentException;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeployerRecoveryLog {
    private static final String REDEPLOY_FILE_NAME = "deployed";
    private static final String REDEPLOY_COMPRESSION_FILE_NAME = "deployed.compress";
    private static final int INITIAL_REDEPLOY_DATA_SIZE = 32768;
    private static final int COMPRESSION_THRESHOLD = 10;
    private static final int COMMAND_LENGTH = 3;
    private static final String UNDEPLOY_URI_COMMAND = "---";
    private static final String URI_SEPARATOR = ";";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PathReference redeployDataset;
    private final PathReference redeployCompressionDataset;
    private final long redeployFileLastModified;

    DeployerRecoveryLog(PathReference workArea) {
        PathReference recoveryArea = workArea.newChild("recovery");
        recoveryArea.createDirectory();
        this.redeployDataset = recoveryArea.newChild(REDEPLOY_FILE_NAME);
        this.redeployFileLastModified = this.redeployDataset.toFile().lastModified();
        this.redeployCompressionDataset = recoveryArea.newChild(REDEPLOY_COMPRESSION_FILE_NAME);
        if (!this.redeployDataset.exists() && this.redeployCompressionDataset.exists()) {
            this.redeployCompressionDataset.copy(this.redeployDataset);
            if (!this.redeployCompressionDataset.delete()) {
                this.logger.warn("Could not delete '%s' in recovery after compression failure.", (Object)this.redeployCompressionDataset);
            }
        }
    }

    public Map<URI, DeploymentOptions> getRecoveryState() {
        LinkedHashMap<URI, DeploymentOptions> redeploySet = new LinkedHashMap<URI, DeploymentOptions>(20);
        String redeployData = this.readRedployData();
        int recordCount = 0;
        int undeployCount = 0;
        String[] stringArray = redeployData.split(URI_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uriCommandString = stringArray[n2];
            ++recordCount;
            if (uriCommandString.length() >= 3) {
                String uriCommand = uriCommandString.substring(0, 3);
                String uriString = uriCommandString.substring(3);
                try {
                    URI uri = new URI(uriString);
                    if (UNDEPLOY_URI_COMMAND.equals(uriCommand)) {
                        ++undeployCount;
                        redeploySet.remove(uri);
                    } else {
                        char[] commands = uriCommand.toCharArray();
                        DeploymentOptions options = new DeploymentOptions(DeployerRecoveryLog.fromCommandOption(commands[0]), DeployerRecoveryLog.fromCommandOption(commands[1]), DeployerRecoveryLog.fromCommandOption(commands[2]));
                        redeploySet.put(uri, options);
                    }
                }
                catch (URISyntaxException e) {
                    this.logger.error("Invalid URI in command string '%s' read from redeploy dataset", (Object)e, (Object)uriCommandString);
                }
            }
            ++n2;
        }
        if (10 * undeployCount > recordCount) {
            this.rewriteRedeploySet(redeploySet);
        }
        return redeploySet;
    }

    private String readRedployData() {
        StringBuffer redeployData;
        block14: {
            redeployData = new StringBuffer(32768);
            BufferedReader redeployDataReader = null;
            try {
                redeployDataReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.redeployDataset.toFile()), StandardCharsets.UTF_8));
                try {
                    try {
                        int numRead;
                        char[] chars = new char[32768];
                        while (-1 != (numRead = redeployDataReader.read(chars))) {
                            redeployData.append(String.valueOf(chars, 0, numRead));
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Problem reading redeploy dataset", (Throwable)e);
                        try {
                            ((Reader)redeployDataReader).close();
                        }
                        catch (IOException e2) {
                            this.logger.error("Problem closing redeploy dataset", (Throwable)e2);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)redeployDataReader).close();
                    }
                    catch (IOException e) {
                        this.logger.error("Problem closing redeploy dataset", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    ((Reader)redeployDataReader).close();
                }
                catch (IOException e) {
                    this.logger.error("Problem closing redeploy dataset", (Throwable)e);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return redeployData.toString();
    }

    private void rewriteRedeploySet(Map<URI, DeploymentOptions> redeploySet) {
        this.redeployCompressionDataset.delete();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter redeployDataWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.redeployCompressionDataset.toFile()), StandardCharsets.UTF_8));){
                for (Map.Entry<URI, DeploymentOptions> redeployEntry : redeploySet.entrySet()) {
                    DeployerRecoveryLog.recordUriCommand(redeployDataWriter, redeployEntry.getKey(), this.getCommandString(redeployEntry.getValue()));
                }
                ((Writer)redeployDataWriter).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.warn("Problem while rewriting redeploy dataset", (Throwable)e);
        }
        this.redeployDataset.delete();
        this.redeployCompressionDataset.moveTo(this.redeployDataset);
    }

    void add(URI location, DeploymentOptions deploymentOptions) {
        this.recordUriCommand(location, this.getCommandString(deploymentOptions));
    }

    private String getCommandString(DeploymentOptions deploymentOptions) {
        StringBuilder command = new StringBuilder().append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getRecoverable())).append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getDeployerOwned())).append(DeployerRecoveryLog.toCommandOption(deploymentOptions.getSynchronous()));
        return command.toString();
    }

    void remove(URI location) {
        this.recordUriCommand(location, UNDEPLOY_URI_COMMAND);
    }

    private void recordUriCommand(URI uri, String command) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter writer = new FileWriter(this.redeployDataset.toFile(), true);){
                DeployerRecoveryLog.recordUriCommand(writer, uri, command);
                ((Writer)writer).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalDeploymentException("Failed to record (un)deployment", (Throwable)e);
        }
    }

    private static void recordUriCommand(Writer writer, URI uri, String command) throws IOException {
        writer.write(command);
        writer.write(uri.toString());
        writer.write(URI_SEPARATOR);
    }

    private static char toCommandOption(boolean deploymentOption) {
        return deploymentOption ? (char)'Y' : 'N';
    }

    private static boolean fromCommandOption(char commandOption) {
        return 'Y' == commandOption;
    }

    public long getRedeployFileLastModified() {
        return this.redeployFileLastModified;
    }

    public boolean setRedeployFileLastModified() {
        return this.redeployDataset.touch();
    }
}

