/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final SimpUserRegistry userRegistry;
    private String prefix = "/user/";
    private boolean keepLeadingSlash = true;

    public DefaultUserDestinationResolver(SimpUserRegistry userRegistry) {
        Assert.notNull((Object)userRegistry, (String)"'userRegistry' must not be null");
        this.userRegistry = userRegistry;
    }

    public SimpUserRegistry getSimpUserRegistry() {
        return this.userRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.prefix;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        if (pathMatcher != null) {
            this.keepLeadingSlash = pathMatcher.combine("1", "2").equals("1/2");
        }
    }

    @Override
    public UserDestinationResult resolveDestination(Message<?> message) {
        ParseResult parseResult = this.parse(message);
        if (parseResult == null) {
            return null;
        }
        String user = parseResult.getUser();
        String sourceDestination = parseResult.getSourceDestination();
        HashSet<String> targetSet = new HashSet<String>();
        for (String sessionId : parseResult.getSessionIds()) {
            String actualDestination = parseResult.getActualDestination();
            String targetDestination = this.getTargetDestination(sourceDestination, actualDestination, sessionId, user);
            if (targetDestination == null) continue;
            targetSet.add(targetDestination);
        }
        String subscribeDestination = parseResult.getSubscribeDestination();
        return new UserDestinationResult(sourceDestination, targetSet, subscribeDestination, user);
    }

    private ParseResult parse(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        String sourceDestination = SimpMessageHeaderAccessor.getDestination(headers);
        if (sourceDestination == null || !this.checkDestination(sourceDestination, this.prefix)) {
            return null;
        }
        SimpMessageType messageType = SimpMessageHeaderAccessor.getMessageType(headers);
        switch (messageType) {
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                return this.parseSubscriptionMessage(message, sourceDestination);
            }
            case MESSAGE: {
                return this.parseMessage(headers, sourceDestination);
            }
        }
        return null;
    }

    private ParseResult parseSubscriptionMessage(Message<?> message, String sourceDestination) {
        Principal principal;
        MessageHeaders headers = message.getHeaders();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (sessionId == null) {
            logger.error((Object)("No session id. Ignoring " + message));
            return null;
        }
        int prefixEnd = this.prefix.length() - 1;
        String actualDestination = sourceDestination.substring(prefixEnd);
        if (!this.keepLeadingSlash) {
            actualDestination = actualDestination.substring(1);
        }
        String user = (principal = SimpMessageHeaderAccessor.getUser(headers)) != null ? principal.getName() : null;
        Set<String> sessionIds = Collections.singleton(sessionId);
        return new ParseResult(sourceDestination, actualDestination, sourceDestination, sessionIds, user);
    }

    private ParseResult parseMessage(MessageHeaders headers, String sourceDestination) {
        Set<String> sessionIds;
        int prefixEnd = this.prefix.length();
        int userEnd = sourceDestination.indexOf(47, prefixEnd);
        Assert.isTrue((userEnd > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/user/{userId}/**\"");
        String actualDestination = sourceDestination.substring(userEnd);
        String subscribeDestination = this.prefix.substring(0, prefixEnd - 1) + actualDestination;
        String userName = sourceDestination.substring(prefixEnd, userEnd);
        userName = StringUtils.replace((String)userName, (String)"%2F", (String)"/");
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        if (userName.equals(sessionId)) {
            userName = null;
            sessionIds = Collections.singleton(sessionId);
        } else {
            sessionIds = this.getSessionIdsByUser(userName, sessionId);
        }
        if (!this.keepLeadingSlash) {
            actualDestination = actualDestination.substring(1);
        }
        return new ParseResult(sourceDestination, actualDestination, subscribeDestination, sessionIds, userName);
    }

    private Set<String> getSessionIdsByUser(String userName, String sessionId) {
        Set<String> sessionIds;
        SimpUser user = this.userRegistry.getUser(userName);
        if (user != null) {
            if (user.getSession(sessionId) != null) {
                sessionIds = Collections.singleton(sessionId);
            } else {
                Set<SimpSession> sessions = user.getSessions();
                sessionIds = new HashSet<String>(sessions.size());
                for (SimpSession session : sessions) {
                    sessionIds.add(session.getId());
                }
            }
        } else {
            sessionIds = Collections.emptySet();
        }
        return sessionIds;
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        return destination.startsWith(requiredPrefix);
    }

    protected String getTargetDestination(String sourceDestination, String actualDestination, String sessionId, String user) {
        return actualDestination + "-user" + sessionId;
    }

    public String toString() {
        return "DefaultUserDestinationResolver[prefix=" + this.prefix + "]";
    }

    private static class ParseResult {
        private final String sourceDestination;
        private final String actualDestination;
        private final String subscribeDestination;
        private final Set<String> sessionIds;
        private final String user;

        public ParseResult(String sourceDest, String actualDest, String subscribeDest, Set<String> sessionIds, String user) {
            this.sourceDestination = sourceDest;
            this.actualDestination = actualDest;
            this.subscribeDestination = subscribeDest;
            this.sessionIds = sessionIds;
            this.user = user;
        }

        public String getSourceDestination() {
            return this.sourceDestination;
        }

        public String getActualDestination() {
            return this.actualDestination;
        }

        public String getSubscribeDestination() {
            return this.subscribeDestination;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }

        public String getUser() {
            return this.user;
        }
    }
}

