/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.util.io.PathReference;

final class FileMovingArtifactStore
extends AbstractArtifactStore
implements ArtifactStore {
    private final PathReference currentPath;
    private final PathReference savedPath;

    FileMovingArtifactStore(PathReference basePathReference) {
        super(basePathReference);
        this.currentPath = basePathReference;
        this.savedPath = new PathReference(String.format("%s-saved", this.currentPath.getAbsolutePath()));
        this.currentPath.getParent().createDirectory();
        this.currentPath.delete(true);
    }

    @Override
    public void save() {
        if (this.currentPath.exists()) {
            this.savedPath.delete(true);
            this.currentPath.moveTo(this.savedPath);
        }
        super.save();
    }

    @Override
    public void restore() {
        super.restore();
        if (this.savedPath.exists()) {
            this.savedPath.moveTo(this.currentPath);
        }
    }

    @Override
    public PathReference getCurrentPath() {
        return this.currentPath;
    }

    @Override
    protected PathReference getSavedPath() {
        return this.savedPath;
    }
}

