/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphVisitor;

final class SubgraphTraverser {
    SubgraphTraverser() {
    }

    void visitSubgraph(Region startingRegion, RegionDigraphVisitor visitor) {
        this.visitRemainingSubgraph(startingRegion, visitor, new HashSet<Region>());
    }

    private void visitRemainingSubgraph(Region r, RegionDigraphVisitor visitor, Set<Region> path) {
        if (!path.contains(r) && visitor.visit(r)) {
            this.traverseEdges(r, visitor, path);
        }
    }

    private void traverseEdges(Region r, RegionDigraphVisitor visitor, Set<Region> path) {
        for (RegionDigraph.FilteredRegion fr : r.getEdges()) {
            if (!visitor.preEdgeTraverse(fr.getFilter())) continue;
            try {
                this.visitRemainingSubgraph(fr.getRegion(), visitor, this.extendPath(r, path));
            }
            finally {
                visitor.postEdgeTraverse(fr.getFilter());
            }
        }
    }

    private Set<Region> extendPath(Region r, Set<Region> path) {
        HashSet<Region> newPath = new HashSet<Region>(path);
        newPath.add(r);
        return newPath;
    }
}

