/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.util.HashMap;
import java.util.Map;
import org.jolokia.config.Configuration;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.ExecHandler;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.ListHandler;
import org.jolokia.handler.ReadHandler;
import org.jolokia.handler.SearchHandler;
import org.jolokia.handler.VersionHandler;
import org.jolokia.handler.WriteHandler;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

public class RequestHandlerManager {
    private final Map<RequestType, JsonRequestHandler> requestHandlerMap = new HashMap<RequestType, JsonRequestHandler>();

    public RequestHandlerManager(Configuration pConfig, Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        JsonRequestHandler[] handlers;
        for (JsonRequestHandler handler : handlers = new JsonRequestHandler[]{new ReadHandler(pRestrictor), new WriteHandler(pRestrictor, pConverters), new ExecHandler(pRestrictor, pConverters), new ListHandler(pRestrictor), new VersionHandler(pConfig, pRestrictor, pServerHandle), new SearchHandler(pRestrictor)}) {
            this.requestHandlerMap.put(handler.getType(), handler);
        }
    }

    public RequestHandlerManager(Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        this(null, pConverters, pServerHandle, pRestrictor);
    }

    public JsonRequestHandler getRequestHandler(RequestType pType) {
        JsonRequestHandler handler = this.requestHandlerMap.get((Object)pType);
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported operation '" + (Object)((Object)pType) + "'");
        }
        return handler;
    }
}

