/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal.ovf;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.virgo.nano.config.internal.ovf.OvfParseException;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class OvfEnvironmentPropertiesReader {
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ELEMENT_PROPERTY = "Property";
    private static final String NAMESPACE_ENVIRONMENT = "http://schemas.dmtf.org/ovf/environment/1";

    OvfEnvironmentPropertiesReader() {
        try {
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public Properties readProperties(Reader documentReader) {
        try {
            Properties result = new Properties();
            Document doc = this.readDocument(documentReader);
            this.parseProperties(doc, result);
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void parseProperties(Document doc, Properties result) {
        try {
            NodeList propertyElements = doc.getElementsByTagNameNS(NAMESPACE_ENVIRONMENT, ELEMENT_PROPERTY);
            int x = 0;
            while (x < propertyElements.getLength()) {
                Element propertyElement = (Element)propertyElements.item(x);
                String key = propertyElement.getAttributeNS(NAMESPACE_ENVIRONMENT, ATTRIBUTE_KEY);
                String value = propertyElement.getAttributeNS(NAMESPACE_ENVIRONMENT, ATTRIBUTE_VALUE);
                result.setProperty(key, value);
                ++x;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Document readDocument(Reader documentReader) {
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                return builder.parse(new InputSource(documentReader));
            }
            catch (ParserConfigurationException e) {
                throw new OvfParseException("Error configuring XML parser.", e);
            }
            catch (SAXException e) {
                throw new OvfParseException("Error parsing OVF XML document.", e);
            }
            catch (IOException e) {
                throw new OvfParseException("Error reading OVF XML document.", e);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

