/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal.commandline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.config.internal.PropertiesSource;
import org.eclipse.virgo.kernel.diagnostics.KernelLogEvents;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;

public final class CommandLinePropertiesSource
implements PropertiesSource {
    private static final String PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS = "commandLineArtifacts";
    private static final String PROPERTY_UNRECOGNIZED_LAUNCHER_ARGUMENTS = "org.eclipse.virgo.osgi.launcher.unrecognizedArguments";
    private static final String COMMAND_PREFIX = "-";
    private static final String COMMAND_PLAN = "plan";
    private static final String PID_KERNEL_REGION = "org.eclipse.virgo.kernel.userregion";
    private static final String TEMPLATE_VERSIONED_PLAN_REPOSITORY_URI = "repository:plan/%s/%s";
    private static final String TEMPLATE_UNVERSIONED_PLAN_REPOSITORY_URI = "repository:plan/%s";
    private final String unrecognizedArguments;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public CommandLinePropertiesSource(BundleContext bundleContext, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.unrecognizedArguments = bundleContext.getProperty(PROPERTY_UNRECOGNIZED_LAUNCHER_ARGUMENTS);
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            HashMap<String, Properties> configuration = new HashMap<String, Properties>();
            if (this.unrecognizedArguments != null) {
                String[] components = this.unrecognizedArguments.split(",");
                ArrayList<String> arguments = null;
                String command = null;
                int i = 0;
                while (i < components.length) {
                    if (components[i].startsWith(COMMAND_PREFIX)) {
                        if (command != null) {
                            this.processCommand(command, arguments, configuration);
                        }
                        command = components[i].substring(COMMAND_PREFIX.length());
                        arguments = new ArrayList<String>();
                    } else if (arguments != null) {
                        arguments.add(components[i]);
                    }
                    ++i;
                }
                if (command != null) {
                    this.processCommand(command, arguments, configuration);
                }
            }
            this.applyDefaults(configuration);
            return configuration;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void applyDefaults(Map<String, Properties> configuration) {
        try {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                Properties properties = this.getProperties(PID_KERNEL_REGION, configuration);
                String userArtifacts = properties.getProperty(PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS);
                if (userArtifacts == null) {
                    properties.put(PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS, "");
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void processCommand(String command, List<String> arguments, Map<String, Properties> configuration) {
        try {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                if (COMMAND_PLAN.equals(command)) {
                    this.processPlanCommand(arguments, configuration);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void processPlanCommand(List<String> arguments, Map<String, Properties> configuration) {
        try {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                String repositoryUri = null;
                if (arguments.size() == 1) {
                    repositoryUri = String.format(TEMPLATE_UNVERSIONED_PLAN_REPOSITORY_URI, arguments.get(0));
                } else if (arguments.size() == 2) {
                    repositoryUri = String.format(TEMPLATE_VERSIONED_PLAN_REPOSITORY_URI, arguments.get(0), arguments.get(1));
                } else {
                    this.eventLogger.log((LogEvent)KernelLogEvents.KERNEL_PLAN_ARGUMENTS_INCORRECT, new Object[]{arguments.size(), this.formatArgumentList(arguments)});
                }
                if (repositoryUri != null) {
                    Properties properties = this.getProperties(PID_KERNEL_REGION, configuration);
                    this.appendProperty(PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS, repositoryUri, properties);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private String formatArgumentList(List<String> arguments) {
        try {
            String string;
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                if (arguments.size() == 0) {
                    string = "";
                } else {
                    StringBuilder argumentsBuilder = new StringBuilder();
                    int i = 0;
                    while (i < arguments.size()) {
                        argumentsBuilder.append(arguments.get(i));
                        if (i + 1 < arguments.size()) {
                            argumentsBuilder.append(", ");
                        }
                        ++i;
                    }
                    string = argumentsBuilder.toString();
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Properties getProperties(String pid, Map<String, Properties> configuration) {
        try {
            Properties properties = configuration.get(pid);
            if (properties == null) {
                properties = new Properties();
                configuration.put(pid, properties);
            }
            return properties;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendProperty(String key, String value, Properties properties) {
        try {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                String property = properties.getProperty(key);
                property = property != null ? String.valueOf(property) + "," + value : value;
                properties.put(key, property);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            CommandLinePropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("CommandLinePropertiesSource.java", Class.forName("org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "applyDefaults", "org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource", "java.util.Map:", "configuration:", "", "void"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processCommand", "org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource", "java.lang.String:java.util.List:java.util.Map:", "command:arguments:configuration:", "", "void"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "processPlanCommand", "org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource", "java.util.List:java.util.Map:", "arguments:configuration:", "", "void"), 98);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatArgumentList", "org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource", "java.util.List:", "arguments:", "", "java.lang.String"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "appendProperty", "org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource", "java.lang.String:java.lang.String:java.util.Properties:", "key:value:properties:", "", "void"), 141);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource");
    }
}

