/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.config.internal.ConfigurationAdminConfigurationInfo;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdminExporter
implements ConfigurationListener {
    private final Logger logger;
    private final MBeanServer server;
    private static final String OBJECT_NAME_PATTERN = "%s:type=Configuration,name=%s";
    private final Map<String, ObjectInstance> configurationInfos;
    private final Object monitor;
    private final String managementDomain;
    private final ConfigurationAdmin configurationAdmin;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ConfigurationAdminExporter(String managementDomain, ConfigurationAdmin configurationAdmin) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.server = ManagementFactory.getPlatformMBeanServer();
            this.configurationInfos = new HashMap<String, ObjectInstance>();
            this.monitor = new Object();
            this.managementDomain = managementDomain;
            this.configurationAdmin = configurationAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    try {
                        Configuration[] configurationArray = this.configurationAdmin.listConfigurations(null);
                        int n = configurationArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Configuration configuration = configurationArray[n2];
                            this.exportConfiguration(configuration.getPid());
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.warn("Could not enumerate existing configurations");
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        try {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                String pid = configurationEvent.getPid();
                if (1 == configurationEvent.getType()) {
                    this.exportConfiguration(pid);
                } else if (2 == configurationEvent.getType()) {
                    this.unexportConfiguration(pid);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private ObjectName getObjectName(String pid) throws MalformedObjectNameException, NullPointerException {
        try {
            return new ObjectName(String.format(OBJECT_NAME_PATTERN, this.managementDomain, pid));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportConfiguration(String pid) {
        try {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    if (!this.configurationInfos.containsKey(pid)) {
                        try {
                            ConfigurationAdminConfigurationInfo configurationInfo = new ConfigurationAdminConfigurationInfo(this.configurationAdmin, pid);
                            ObjectInstance objectInstance = this.server.registerMBean(configurationInfo, this.getObjectName(pid));
                            this.configurationInfos.put(pid, objectInstance);
                        }
                        catch (JMException jMException) {
                            this.logger.warn("Unable to register MBean for configuration '{}'", (Object)pid);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unexportConfiguration(String pid) {
        try {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                ObjectName objectName = null;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.configurationInfos.containsKey(pid)) {
                        objectName = this.configurationInfos.remove(pid).getObjectName();
                    }
                }
                if (objectName != null) {
                    try {
                        this.server.unregisterMBean(objectName);
                    }
                    catch (JMException jMException) {
                        this.logger.warn("Unable to unregister MBean for configuration '{}'", (Object)pid);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            try {
                ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
                Object object = this.monitor;
                synchronized (object) {
                    Set<Map.Entry<String, ObjectInstance>> entries = this.configurationInfos.entrySet();
                    for (Map.Entry<String, ObjectInstance> entry : entries) {
                        objectNames.add(entry.getValue().getObjectName());
                    }
                    this.configurationInfos.clear();
                }
                for (ObjectName objectName : objectNames) {
                    try {
                        this.server.unregisterMBean(objectName);
                    }
                    catch (JMException jMException) {
                        this.logger.warn("Unable to unregister MBean '{}' during stop", (Object)objectName);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationAdminExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigurationAdminExporter.java", Class.forName("org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter", "", "", "", "void"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configurationEvent", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter", "org.osgi.service.cm.ConfigurationEvent:", "configurationEvent:", "", "void"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "exportConfiguration", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter", "java.lang.String:", "pid:", "", "void"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unexportConfiguration", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter", "java.lang.String:", "pid:", "", "void"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter", "", "", "", "void"), 118);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter");
    }
}

