/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import javax.validation.Configuration;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheValidationProvider
implements ValidationProvider<ApacheValidatorConfiguration> {
    private static final Class<?>[] VALIDATOR_FACTORY_CONSTRUCTOR_ARGS = new Class[]{ConfigurationState.class};

    public boolean isSuitable(Class<? extends Configuration<?>> builderClass) {
        return ApacheValidatorConfiguration.class == builderClass;
    }

    public ConfigurationImpl createSpecializedConfiguration(BootstrapState state) {
        return new ConfigurationImpl(state, this);
    }

    public Configuration<?> createGenericConfiguration(BootstrapState state) {
        return new ConfigurationImpl(state, null);
    }

    public ValidatorFactory buildValidatorFactory(ConfigurationState configuration) {
        try {
            String validatorFactoryClassname = (String)configuration.getProperties().get("apache.bval.validator-factory-classname");
            Class validatorFactoryClass = validatorFactoryClassname == null ? ApacheValidatorFactory.class : ClassUtils.getClass((String)validatorFactoryClassname);
            return (ValidatorFactory)SecureActions.newInstance(validatorFactoryClass, VALIDATOR_FACTORY_CONSTRUCTOR_ARGS, new Object[]{configuration});
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ValidationException("error building ValidatorFactory", (Throwable)ex);
        }
    }
}

