/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptors;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBInterceptorConfig {
    private final WebBeansContext webBeansContext;

    public EJBInterceptorConfig(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void configure(Class<?> clazz, List<InterceptorData> stack) {
        Asserts.nullCheckForClass(clazz);
        if (AnnotationUtil.hasClassAnnotation(clazz, Interceptors.class)) {
            Class[] intClasses;
            Interceptors incs = clazz.getAnnotation(Interceptors.class);
            for (Class intClass : intClasses = incs.value()) {
                this._configureInterceptorAnnots(intClass, stack, false, null);
            }
        }
        this._configureBeanAnnots(clazz, stack);
        this.webBeansContext.getInterceptorUtil().filterOverridenLifecycleInterceptor(clazz, stack);
    }

    private void _configureInterceptorAnnots(Class<?> clazz, List<InterceptorData> stack, boolean isMethod, Method m) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this._configureInterceptorAnnots(superClass, stack, false, null);
        }
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, true, isMethod, stack, m, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, true, isMethod, stack, m, false);
    }

    private void _configureBeanAnnots(Class<?> clazz, List<InterceptorData> stack) {
        Method[] methods;
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            Class[] intClasses;
            Interceptors incs = method.getAnnotation(Interceptors.class);
            if (incs == null) continue;
            for (Class intClass : intClasses = incs.value()) {
                this._configureInterceptorAnnots(intClass, stack, true, method);
            }
        }
        List<Class<?>> listSuperClazz = ClassUtil.getSuperClasses(clazz, new ArrayList());
        this._configureBeanSuperClassAnnots(listSuperClazz, stack);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
        this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
    }

    private void _configureBeanSuperClassAnnots(List<Class<?>> list, List<InterceptorData> stack) {
        int i = list.size();
        for (int j = i - 1; j >= 0; --j) {
            Class<?> clazz = list.get(j);
            if (clazz.equals(Object.class)) continue;
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, AroundTimeout.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
            this.webBeansContext.getWebBeansUtil().configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
        }
    }
}

