/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

public abstract class AbstractJPQLGrammar
implements JPQLGrammar {
    private JPQLGrammar jpqlGrammar;
    private ExpressionRegistry registry;

    protected AbstractJPQLGrammar() {
        this.initialize();
    }

    protected AbstractJPQLGrammar(AbstractJPQLGrammar jpqlGrammar) {
        this.initialize(jpqlGrammar);
    }

    public void addChildBNF(String queryBNFId, String childQueryBNFId) {
        this.registry.addChildBNF(queryBNFId, childQueryBNFId);
    }

    public void addChildFactory(String queryBNFId, String childExpressionFactoryId) {
        this.registry.addChildFactory(queryBNFId, childExpressionFactoryId);
    }

    public void addIdentifier(String expressionFactoryId, String identifier) {
        this.registry.addIdentifier(expressionFactoryId, identifier);
    }

    public void addIdentifiers(String expressionFactoryId, String ... identifiers) {
        this.registry.addIdentifiers(expressionFactoryId, identifiers);
    }

    protected abstract JPQLGrammar buildBaseGrammar();

    protected ExpressionRegistry buildExpressionRegistry() {
        return new ExpressionRegistry();
    }

    public JPQLGrammar getBaseGrammar() {
        return this.jpqlGrammar;
    }

    public ExpressionRegistry getExpressionRegistry() {
        return this.registry;
    }

    protected void initialize() {
        this.jpqlGrammar = this.buildBaseGrammar();
        this.registry = this.jpqlGrammar == null ? this.buildExpressionRegistry() : this.jpqlGrammar.getExpressionRegistry();
        this.initializeIdentifiers();
        this.initializeBNFs();
        this.initializeExpressionFactories();
    }

    private void initialize(AbstractJPQLGrammar jpqlGrammar) {
        this.registry = jpqlGrammar.registry;
        this.initializeIdentifiers();
        this.initializeBNFs();
        this.initializeExpressionFactories();
    }

    protected abstract void initializeBNFs();

    protected abstract void initializeExpressionFactories();

    protected abstract void initializeIdentifiers();

    protected void registerBNF(JPQLQueryBNF queryBNF) {
        this.registry.registerBNF(queryBNF);
    }

    protected void registerFactory(ExpressionFactory expressionFactory) {
        this.registry.registerFactory(expressionFactory);
    }

    protected void registerIdentifierRole(String identifier, IdentifierRole role) {
        this.registry.registerIdentifierRole(identifier, role);
    }

    protected void registerIdentifierVersion(String identifier, JPAVersion version) {
        this.registry.registerIdentifierVersion(identifier, version);
    }

    public void setFallbackBNFId(String queryBNFId, String fallbackBNFId) {
        this.registry.setFallbackBNFId(queryBNFId, fallbackBNFId);
    }

    public void setHandleSubExpression(String queryBNFId, boolean handleSubExpression) {
        this.registry.setHandleSubExpression(queryBNFId, handleSubExpression);
    }

    public void setFallbackExpressionFactoryId(String queryBNFId, String fallbackExpressionFactoryId) {
        this.registry.setFallbackExpressionFactoryId(queryBNFId, fallbackExpressionFactoryId);
    }
}

