/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.IOUtils;

final class UserConfigurationPropertiesSource
implements PropertiesSource {
    private static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private static final FilenameFilter PROPERTIES_FILENAME_FILTER;
    private final File[] kernelConfigDirectories;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("UserConfigurationPropertiesSource.java", Class.forName("org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readPropertiesFromFile", "org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource", "java.io.File:", "file:", "", "java.util.Properties"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "createPid", "org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource", "java.io.File:", "file:", "", "java.lang.String"), 111);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "trimExtension", "org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource", "java.lang.String:", "name:", "", "java.lang.String"), 115);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "computePid", "org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource", "java.io.File:java.util.Properties:java.util.Set:", "file:properties:existingPids:", "", "java.lang.String"), 120);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource");
        PROPERTIES_FILENAME_FILTER = new FilenameFilter(){
            private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            {
                try {
                    try {
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                    return;
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }

            @Override
            public boolean accept(File dir, String name) {
                try {
                    boolean bl;
                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    try {
                        bl = name.endsWith(UserConfigurationPropertiesSource.PROPERTIES_FILE_SUFFIX);
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                    return bl;
                }
                catch (Throwable throwable) {
                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }

            static {
                Factory factory = new Factory("UserConfigurationPropertiesSource.java", Class.forName("org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource$1"));
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "accept", "org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource$1", "java.io.File:java.lang.String:", "dir:name:", "", "boolean"), 50);
                ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource$1");
            }
        };
    }

    public UserConfigurationPropertiesSource(File[] kernelConfigDirectories) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.kernelConfigDirectories = kernelConfigDirectories;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            TreeMap<String, Properties> result = new TreeMap<String, Properties>();
            File[] fileArray = this.kernelConfigDirectories;
            int n = this.kernelConfigDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File[] configFiles;
                File dir = fileArray[n2];
                File[] fileArray2 = configFiles = UserConfigurationPropertiesSource.getPropertiesFiles(dir);
                int n3 = configFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    Properties properties = this.readPropertiesFromFile(file);
                    String pid = this.computePid(file, properties, result.keySet());
                    result.put(pid, properties);
                    ++n4;
                }
                ++n2;
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static File[] getPropertiesFiles(File directory) {
        try {
            if (directory.isDirectory()) {
                return FileSystemUtils.listFiles((File)directory, (FilenameFilter)PROPERTIES_FILENAME_FILTER);
            }
            return new File[0];
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties readPropertiesFromFile(File file) {
        try {
            Properties properties;
            block9: {
                UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                try {
                    if (!file.exists()) {
                        properties = null;
                        break block9;
                    }
                    Properties props = new Properties();
                    BufferedInputStream is = null;
                    try {
                        try {
                            is = new BufferedInputStream(new FileInputStream(file));
                            props.load(is);
                        }
                        catch (IOException iOException) {
                            IOUtils.closeQuietly(is);
                            properties = null;
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)is);
                    properties = props;
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
            }
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return properties;
        }
        catch (Throwable throwable) {
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static String createPid(File file) {
        try {
            String string;
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                string = UserConfigurationPropertiesSource.trimExtension(file.getName());
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return string;
        }
        catch (Throwable throwable) {
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static String trimExtension(String name) {
        try {
            String string;
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                int lpDot = name.lastIndexOf(46);
                string = lpDot == -1 ? name : name.substring(0, lpDot);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return string;
        }
        catch (Throwable throwable) {
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private String computePid(File file, Properties properties, Set<String> existingPids) {
        try {
            String string;
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                String pid = properties.getProperty("service.factoryPid");
                string = StringUtils.hasText((String)pid) ? String.valueOf(pid) + "-" + UserConfigurationPropertiesSource.createPid(file) : (StringUtils.hasText((String)(pid = properties.getProperty("service.pid"))) ? pid : UserConfigurationPropertiesSource.createPid(file));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            UserConfigurationPropertiesSource.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }
}

