/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class DefaultNode
extends ValueNode {
    private String columnName;
    private String defaultText;
    private ValueNode defaultTree;

    public void init(Object object, Object object2) {
        this.defaultTree = (ValueNode)object;
        this.defaultText = (String)object2;
    }

    public void init(Object object) {
        this.columnName = (String)object;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    ValueNode getDefaultTree() {
        return this.defaultTree;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        TableDescriptor tableDescriptor = ((FromBaseTable)fromList.elementAt(0)).getTableDescriptor();
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnName);
        DefaultInfoImpl defaultInfoImpl = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
        if (defaultInfoImpl != null) {
            String string = defaultInfoImpl.getDefaultText();
            ValueNode valueNode = DefaultNode.parseDefault(string, this.getLanguageConnectionContext(), this.getCompilerContext());
            DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(this.getDataDictionary());
            this.getCompilerContext().createDependency(defaultDescriptor);
            return valueNode.bindExpression(fromList, subqueryList, vector);
        }
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(13, this.getContextManager());
        return valueNode;
    }

    public static ValueNode parseDefault(String string, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
        String string2 = "VALUES " + string;
        CompilerContext compilerContext2 = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext2.getParser();
        StatementNode statementNode = parser.parseStatement(string2);
        ValueNode valueNode = ((ResultColumn)((CursorNode)statementNode).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        languageConnectionContext.popCompilerContext(compilerContext2);
        return valueNode;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    protected boolean isEquivalent(ValueNode valueNode) {
        return false;
    }
}

