/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.RefreshException;
import org.eclipse.virgo.kernel.install.artifact.internal.StartEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StartException;
import org.eclipse.virgo.kernel.install.artifact.internal.StopEngine;
import org.eclipse.virgo.kernel.install.artifact.internal.StopException;
import org.eclipse.virgo.nano.deployer.api.config.ConfigurationDeployer;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigLifecycleEngine
implements StartEngine,
RefreshEngine,
StopEngine {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleContext context;
    private ConfigurationDeployer configurationDeployer;

    public ConfigLifecycleEngine(BundleContext context) {
        this.context = context;
    }

    @Override
    public void start(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StartException {
        this.initialiseConfigurationDeployer();
        try {
            this.updateConfiguration(artifactIdentity, artifactFS);
        }
        catch (IOException e) {
            String message = String.format("Unable to start configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
            this.logger.error(message);
            throw new StartException(message, e);
        }
    }

    private void initialiseConfigurationDeployer() {
        ServiceReference configurationImporterRef = this.context.getServiceReference(ConfigurationDeployer.class);
        this.configurationDeployer = (ConfigurationDeployer)this.context.getService(configurationImporterRef);
    }

    @Override
    public void refresh(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws RefreshException {
        try {
            this.updateConfiguration(artifactIdentity, artifactFS);
        }
        catch (IOException e) {
            String message = String.format("Unable to refresh configuration '%s' with '%s'", artifactIdentity.getName(), artifactFS);
            this.logger.error(message);
            throw new RefreshException(message, e);
        }
    }

    private void updateConfiguration(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = artifactFS.getEntry("").getInputStream();
            this.configurationDeployer.publishConfiguration(artifactIdentity.getName(), this.getProperties(inputStream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    private Properties getProperties(InputStream inputSteam) throws IOException {
        Properties p = new Properties();
        p.load(inputSteam);
        return p;
    }

    @Override
    public void stop(ArtifactIdentity artifactIdentity, ArtifactFS artifactFS) throws StopException {
        try {
            this.configurationDeployer.deleteConfiguration(artifactIdentity.getName());
        }
        catch (IOException e) {
            String message = String.format("Unable to stop configuration '%s'", artifactIdentity.getName());
            this.logger.error(message);
            throw new StopException(message, e);
        }
    }
}

