/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl.summary;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;

public final class SummaryDumpContributor
implements DumpContributor {
    private final DateFormat dateFormat = DateFormat.getDateInstance();
    private final DateFormat timeFormat = DateFormat.getTimeInstance(1);
    private final Object formatterLock = new Object();

    public void contribute(Dump dump) throws DumpContributionFailedException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(dump.createFileWriter("summary.txt"));
            this.processHeader(writer, dump.getTimestamp());
            SummaryDumpContributor.processCause(writer, dump.getCause());
            SummaryDumpContributor.processThrowables(writer, dump.getThrowables());
        }
    }

    public String getName() {
        return "summary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeader(PrintWriter dump, long timestamp) {
        Object object = this.formatterLock;
        synchronized (object) {
            dump.println("Date:\t\t" + this.dateFormat.format(new Date(timestamp)));
            dump.println("Time:\t\t" + this.timeFormat.format(new Date(timestamp)));
        }
    }

    private static void processCause(PrintWriter dump, String cause) {
        dump.println();
        dump.println("Cause: " + cause);
    }

    private static void processThrowables(PrintWriter dump, Throwable ... throwables) {
        if (throwables.length == 0) {
            dump.println();
            dump.println("Exception: None");
        } else {
            Throwable[] throwableArray = throwables;
            int n = throwables.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable throwable = throwableArray[n2];
                dump.println();
                dump.println("Exception:");
                throwable.printStackTrace(dump);
                ++n2;
            }
        }
    }
}

