/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.Stateful;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.util.WebBeansUtil;

public class CdiPlugin
extends AbstractOwbPlugin
implements OpenWebBeansJavaEEPlugin,
OpenWebBeansEjbPlugin {
    private Set<Class<?>> beans;
    private WebBeansContext webBeansContext;
    private CdiAppContextsService contexsServices;
    private ClassLoader classLoader;
    private final Map<Contextual<?>, Object> cacheProxies = new ConcurrentHashMap();

    public void setWebBeansContext(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void shutDown() {
        super.shutDown();
        if (this.beans != null) {
            this.beans.clear();
        }
    }

    public void configureDeployments(List<BeanContext> ejbDeployments) {
        WeakHashMap beans = new WeakHashMap();
        for (BeanContext deployment : ejbDeployments) {
            if (!deployment.getComponentType().isSession()) continue;
            beans.put(deployment.getBeanClass(), null);
        }
        this.beans = beans.keySet();
    }

    public CdiAppContextsService getContexsServices() {
        return this.contexsServices;
    }

    public void startup() {
        this.contexsServices = (CdiAppContextsService)this.webBeansContext.getContextsService();
        this.contexsServices.init(null);
    }

    public void stop() throws OpenEJBException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)new BeforeShutdownImpl(), new Annotation[0]);
            this.contexsServices.destroy(null);
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.webBeansContext.getBeanManagerImpl().getInjectionResolver().clearCaches();
            this.webBeansContext.getProxyFactory().clear();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            CdiResourceInjectionService injectionServices = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionServices.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            throw new OpenEJBException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public <T> T getSupportedService(Class<T> serviceClass) {
        return this.supportService(serviceClass) ? (T)serviceClass.cast((Object)this) : null;
    }

    public void isManagedBean(Class<?> clazz) {
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass == TransactionService.class || serviceClass == SecurityService.class;
    }

    public Object getSessionBeanProxy(Bean<?> inBean, Class<?> interfce, CreationalContext<?> creationalContext) {
        Object instance = this.cacheProxies.get(inBean);
        if (instance != null) {
            return instance;
        }
        Class scopeClass = inBean.getScope();
        CdiEjbBean cdiEjbBean = (CdiEjbBean)inBean;
        CreationalContext<?> cc = creationalContext;
        if (scopeClass == null || Dependent.class == scopeClass) {
            return cdiEjbBean.createEjb(cc);
        }
        InstanceBean<Object> bean = new InstanceBean<Object>(cdiEjbBean);
        if (this.webBeansContext.getBeanManagerImpl().isScopeTypeNormal(scopeClass)) {
            instance = this.webBeansContext.getProxyFactory().createNormalScopedBeanProxy(bean, creationalContext);
            this.cacheProxies.put((Contextual<?>)inBean, instance);
        } else {
            Context context = this.webBeansContext.getBeanManagerImpl().getContext(scopeClass);
            instance = context.get(bean, cc);
        }
        bean.setOWBProxy(instance);
        return instance;
    }

    public boolean isSessionBean(Class<?> clazz) {
        return this.beans != null && this.beans.contains(clazz);
    }

    public <T> Bean<T> defineSessionBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotateTypeEvent) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isSingletonBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateful.class);
    }

    public boolean isStatelessBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public Method resolveViewMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        for (Class intface : beanContext.getBusinessLocalInterfaces()) {
            try {
                return intface.getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return declaredMethod;
    }

    public Method resolveBeanMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        try {
            return beanContext.getBeanClass().getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return declaredMethod;
        }
    }

    public void clearProxies() {
        this.cacheProxies.clear();
    }

    private static class InstanceBean<T>
    implements OwbBean<T>,
    PassivationCapable {
        private final CdiEjbBean<T> bean;
        private T OWBProxy;

        public InstanceBean(CdiEjbBean<T> tCdiEjbBean) {
            this.bean = tCdiEjbBean;
        }

        public T createNewInstance(CreationalContext<T> creationalContext) {
            return this.create(creationalContext);
        }

        public void destroyCreatedInstance(T instance, CreationalContext<T> creationalContext) {
            this.bean.destroyComponentInstance(instance, creationalContext);
        }

        public Set<Type> getTypes() {
            return this.bean.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.bean.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.bean.getScope();
        }

        public String getName() {
            return this.bean.getName();
        }

        public boolean isNullable() {
            return this.bean.isNullable();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.bean.getBeanClass();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.bean.getStereotypes();
        }

        public boolean isAlternative() {
            return this.bean.isAlternative();
        }

        public T create(CreationalContext<T> creationalContext) {
            T instance = this.bean.createEjb(creationalContext);
            if (this.OWBProxy != null && SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                this.bean.storeStatefulInstance(this.OWBProxy, instance);
            }
            return instance;
        }

        public void destroy(T instance, CreationalContext<T> cc) {
            if (!SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                return;
            }
            this.bean.destroy(instance, cc);
        }

        public void setImplScopeType(Annotation scopeType) {
        }

        public WebBeansType getWebBeansType() {
            return this.bean.getWebBeansType();
        }

        public void addQualifier(Annotation qualifier) {
        }

        public boolean isSerializable() {
            return this.bean.isSerializable();
        }

        public void addStereoType(Annotation stereoType) {
        }

        public void addApiType(Class<?> apiType) {
        }

        public void addInjectionPoint(InjectionPoint injectionPoint) {
        }

        public Set<Annotation> getOwbStereotypes() {
            return this.bean.getOwbStereotypes();
        }

        public void setName(String name) {
        }

        public List<InjectionPoint> getInjectionPoint(Member member) {
            return Collections.emptyList();
        }

        public Class<T> getReturnType() {
            return this.bean.getReturnType();
        }

        public void setSerializable(boolean serializable) {
        }

        public void setNullable(boolean nullable) {
        }

        public void setSpecializedBean(boolean specialized) {
        }

        public boolean isSpecializedBean() {
            return this.bean.isSpecializedBean();
        }

        public void setEnabled(boolean enabled) {
        }

        public boolean isEnabled() {
            return this.bean.isEnabled();
        }

        public String getId() {
            return this.bean.getId();
        }

        public boolean isPassivationCapable() {
            return this.bean.isPassivationCapable();
        }

        public boolean isDependent() {
            return this.bean.isDependent();
        }

        public void validatePassivationDependencies() {
            this.bean.validatePassivationDependencies();
        }

        public WebBeansContext getWebBeansContext() {
            return this.bean.getWebBeansContext();
        }

        public void setOWBProxy(T OWBProxy) {
            this.OWBProxy = OWBProxy;
        }

        public boolean equals(Object o) {
            return this == o || this.bean == o;
        }

        public int hashCode() {
            return this.bean.hashCode();
        }
    }
}

