/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISessionBuilder {
    private final ServiceContext serviceContext;
    private final UISessionImpl uiSession;

    public UISessionBuilder(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        ApplicationContextImpl applicationContext = serviceContext.getApplicationContext();
        HttpServletRequest request = serviceContext.getRequest();
        HttpSession httpSession = request.getSession(true);
        String connectionId = request.getParameter("cid");
        this.uiSession = new UISessionImpl(applicationContext, httpSession, connectionId);
    }

    public UISessionImpl buildUISession() {
        this.uiSession.attachToHttpSession();
        this.serviceContext.setUISession(this.uiSession);
        SingletonManager.install(this.uiSession);
        this.setCurrentTheme();
        this.selectClient();
        return this.uiSession;
    }

    private void setCurrentTheme() {
        Map<String, String> properties = this.getEntryPointProperties();
        String themeId = properties.get("org.eclipse.rap.rwt.webclient.themeId");
        if (themeId != null && themeId.length() > 0) {
            this.verifyThemeId(themeId);
            ThemeUtil.setCurrentThemeId(this.uiSession, themeId);
        } else {
            ThemeUtil.setCurrentThemeId(this.uiSession, "org.eclipse.rap.rwt.theme.Default");
        }
    }

    private void selectClient() {
        ApplicationContextImpl applicationContext = this.uiSession.getApplicationContext();
        applicationContext.getClientSelector().selectClient(this.serviceContext.getRequest(), this.uiSession);
    }

    private void verifyThemeId(String themeId) {
        ApplicationContextImpl applicationContext = this.uiSession.getApplicationContext();
        if (!applicationContext.getThemeManager().hasTheme(themeId)) {
            throw new IllegalArgumentException("Illegal theme id: " + themeId);
        }
    }

    private Map<String, String> getEntryPointProperties() {
        String servletPath;
        ApplicationContextImpl applicationContext = this.uiSession.getApplicationContext();
        EntryPointManager entryPointManager = applicationContext.getEntryPointManager();
        EntryPointRegistration registration = entryPointManager.getRegistrationByPath(servletPath = this.serviceContext.getRequest().getServletPath());
        Map<String, String> result = registration != null ? registration.getProperties() : Collections.emptyMap();
        return result;
    }
}

