/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.util.Vector;
import javax.transaction.xa.XAException;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XidImpl;
import org.objectweb.jotm.processResourceManager;

public class JotmRecovery {
    private static JotmRecovery unique = null;
    private static Vector vTxRecovered = new Vector();
    private static Vector vRecoverRmInfo = new Vector();
    private Vector userRecoveryRecords = new Vector();
    static String[] HexDigits = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};

    public JotmRecovery() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"JotmRecovery constructor");
        }
        unique = this;
    }

    public static JotmRecovery getJotmRecovery() {
        return unique;
    }

    public static Vector getTxRecovered() {
        return vTxRecovered;
    }

    public static Vector getRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public Vector getmyRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public int getRmIndex(byte[] pxares) {
        int numRm = vRecoverRmInfo.size();
        for (int i = 0; i < numRm; ++i) {
            RecoverRmInfo myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(i);
            byte[] inrmxares = myrecoverRmInfo.getRecoverXaRes();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("XAResource param " + pxares));
                TraceTm.recovery.debug((Object)("XAResource in rm " + inrmxares));
            }
            if (inrmxares != pxares) continue;
            return myrecoverRmInfo.getRecoverIndex();
        }
        return 99;
    }

    public Vector getUserRecoveryVector() {
        return this.userRecoveryRecords;
    }

    public void rebuildTransaction(XALogRecord lr) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"rebuildTransaction");
        }
        RecoverRmInfo myrecoverRmInfo = null;
        TxxidRecovered myrecoverTxInfo = null;
        TxRecovered mytxRecovered = null;
        byte[] rt = new byte[3];
        byte[] rmname = null;
        byte[] txXid = null;
        int xarescount = 0;
        byte[] rt2 = new byte[3];
        XACommittingTx myxacommittx = lr.getTx();
        byte[] tempRec = lr.getFields()[0];
        ByteBuffer rr = ByteBuffer.wrap(tempRec);
        rr.get(rt, 0, 3);
        String trt = new String(rt);
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Recovery Record type= " + trt));
        }
        if (trt.equals("RM1")) {
            long rmdatetime = rr.getLong();
            int rmcount = rr.getInt();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Resource Manager count= " + rmcount));
            }
            for (int i = 1; i <= rmcount; ++i) {
                byte[] resmgr2 = lr.getFields()[i];
                ByteBuffer resm2 = ByteBuffer.wrap(resmgr2);
                resm2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RM2")) continue;
                int rmlength = resm2.getInt();
                rmname = new byte[rmlength];
                resm2.get(rmname, 0, rmlength);
                int xareslength = resm2.getInt();
                byte[] xares = new byte[xareslength];
                resm2.get(xares, 0, xareslength);
                int xaresnamelength = resm2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                resm2.get(xaresname, 0, xaresnamelength);
                int rmindx = resm2.getInt();
                String myrmname = new String(rmname);
                String myxaresname = new String(xaresname);
                myrecoverRmInfo = new RecoverRmInfo();
                myrecoverRmInfo.addRecoverRmXaRes(myrmname, xares, myxaresname, rmindx);
                vRecoverRmInfo.addElement(myrecoverRmInfo);
            }
        } else if (trt.equals("RR1")) {
            long rcdatetime = rr.getLong();
            int intmfi = rr.getInt();
            int gtilen = rr.getInt();
            byte[] mgti = new byte[gtilen];
            rr.get(mgti, 0, gtilen);
            int bqlen = rr.getInt();
            byte[] mbq = new byte[bqlen];
            rr.get(mbq, 0, bqlen);
            byte[] gtrid_local = new byte[64];
            byte[] bqual_local = new byte[64];
            StringBuffer str_buff_gtrid = new StringBuffer(128);
            StringBuffer str_buff_bqual = new StringBuffer(128);
            ByteBuffer aa = ByteBuffer.wrap(gtrid_local);
            System.arraycopy(mgti, 0, gtrid_local, 0, gtilen);
            for (int i = 0; i < gtilen; ++i) {
                JotmRecovery.byteToHex(aa.get(), str_buff_gtrid);
            }
            if (bqlen != 0) {
                bqual_local = new byte[64];
                ByteBuffer bb = ByteBuffer.wrap(bqual_local);
                System.arraycopy(mbq, 0, bqual_local, 0, bqlen);
                for (int i = 0; i < bqlen; ++i) {
                    JotmRecovery.byteToHex(bb.get(), str_buff_bqual);
                }
            }
            byte[] bc = ":".getBytes();
            int bclen = bc.length;
            String sxid = Long.toHexString(intmfi) + ":" + Long.toHexString(gtilen) + ":" + Long.toHexString(bqlen) + ":" + str_buff_gtrid.toString() + ":" + str_buff_bqual.toString();
            txXid = new byte[4 + bclen + 4 + bclen + 4 + gtilen + bclen + bqlen];
            txXid = sxid.getBytes();
            int txdatelength = rr.getInt();
            byte[] txdatetime = new byte[txdatelength];
            rr.get(txdatetime, 0, txdatelength);
            xarescount = rr.getInt();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Rebuilt tx prdt= " + rcdatetime));
                TraceTm.recovery.debug((Object)("Rebuilt tx ptxxid= " + new String(txXid)));
                TraceTm.recovery.debug((Object)("Rebuilt tx ptdt= " + new String(txdatetime)));
            }
            String mytxXid = new String(txXid);
            String mytxdatetime = new String(txdatetime);
            mytxRecovered = new TxRecovered();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("MyTxXid= " + mytxXid));
                TraceTm.recovery.debug((Object)("XAResource count= " + xarescount));
            }
            mytxRecovered.addtxrecovered(rcdatetime, txXid, mytxdatetime, xarescount, myxacommittx);
            for (int i = 1; i <= xarescount; ++i) {
                myrecoverTxInfo = new TxxidRecovered();
                byte[] recov2 = lr.getFields()[i];
                ByteBuffer rr2 = ByteBuffer.wrap(recov2);
                rr2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RR2")) continue;
                int xaresindex = rr2.getInt();
                int xareslength = rr2.getInt();
                byte[] xares = new byte[xareslength];
                rr2.get(xares, 0, xareslength);
                int xaresnamelength = rr2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                rr2.get(xaresname, 0, xaresnamelength);
                int intmfi2 = rr2.getInt();
                int gtilen2 = rr2.getInt();
                byte[] mgti2 = new byte[gtilen2];
                rr2.get(mgti2, 0, gtilen2);
                int bqlen2 = rr2.getInt();
                byte[] mbq2 = new byte[bqlen2];
                rr2.get(mbq2, 0, bqlen2);
                int xidstatus = rr2.getInt();
                byte[] gtrid_local2 = new byte[64];
                byte[] bqual_local2 = new byte[64];
                StringBuffer str_buff_gtrid2 = new StringBuffer(128);
                StringBuffer str_buff_bqual2 = new StringBuffer(128);
                ByteBuffer aa2 = ByteBuffer.wrap(gtrid_local2);
                System.arraycopy(mgti2, 0, gtrid_local2, 0, gtilen2);
                for (int i2 = 0; i2 < gtilen2; ++i2) {
                    JotmRecovery.byteToHex(aa2.get(), str_buff_gtrid2);
                }
                if (bqlen2 != 0) {
                    bqual_local2 = new byte[64];
                    ByteBuffer bb2 = ByteBuffer.wrap(bqual_local2);
                    System.arraycopy(mbq2, 0, bqual_local2, 0, bqlen2);
                    for (int i2 = 0; i2 < bqlen2; ++i2) {
                        JotmRecovery.byteToHex(bb2.get(), str_buff_bqual2);
                    }
                }
                String sxid2 = Long.toHexString(intmfi2) + ":" + Long.toHexString(gtilen2) + ":" + Long.toHexString(bqlen2) + ":" + str_buff_gtrid2.toString() + ":" + str_buff_bqual2.toString();
                byte[] recoveryxid = new byte[4 + bclen + 4 + bclen + 4 + gtilen2 + bclen + bqlen2];
                recoveryxid = sxid2.getBytes();
                String myxaresname = new String(xaresname);
                myrecoverTxInfo.addXidInfo(xaresindex, xares, myxaresname, recoveryxid, xidstatus);
                mytxRecovered.setRecoverTxXidInfo(myrecoverTxInfo, i - 1);
            }
            vTxRecovered.addElement(mytxRecovered);
        } else if (trt.equals("RU1")) {
            XidImpl.setUuids(rr.getLong(), rr.getLong());
        } else {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Unknown record type during replay = " + trt));
            }
            rr.rewind();
            this.userRecoveryRecords.add(rr);
            this.userRecoveryRecords.add(myxacommittx);
        }
    }

    public void recoverTransactions(Vector rmreg) throws XAException {
        int i;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"recoverTransactions");
        }
        int rmregsize = rmreg.size();
        int rmsize = vRecoverRmInfo.size();
        if (rmsize == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Nothing to recover");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("number Resource Manager recover= " + rmsize));
        }
        ThreadGroup resourceManagerThreadGroup = new ThreadGroup("ResourceManagerTG");
        for (i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            String myregrm = myrmreg.rmGetName();
            processResourceManager rmthread = new processResourceManager(resourceManagerThreadGroup, vTxRecovered, vRecoverRmInfo, rmreg, rmsize, i);
            Thread processrm = new Thread(resourceManagerThreadGroup, rmthread, myregrm + "-" + i);
            processrm.start();
        }
        for (int w = 0; w < 10; ++w) {
            boolean rmsinthread = false;
            int numThreads = resourceManagerThreadGroup.activeCount();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("resourceManager active count= " + numThreads));
            }
            if (numThreads == 0) break;
            Thread[] listOfThreads = new Thread[numThreads];
            resourceManagerThreadGroup.enumerate(listOfThreads);
            for (int i2 = 0; i2 < numThreads; ++i2) {
                if (listOfThreads[i2] == null) continue;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("resourceManager in thread= " + listOfThreads[i2].getName()));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                rmsinthread = true;
                break;
            }
            if (!rmsinthread) break;
        }
        this.doCleanupXidRecover();
        for (i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            myrmreg.rmSetRmRecovered(true);
        }
    }

    private void doCleanupXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"doCleanupXidRecover");
        }
        TxxidRecovered myTxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("vTxRecovered.size= " + vTxRecovered.size()));
        }
        for (int i = vTxRecovered.size() - 1; i >= 0; --i) {
            block10: {
                boolean possibleheuristic = false;
                XACommittingTx myxacommittingtx = null;
                mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("mytxRecovered.xidcount= " + mytxRecovered.getxidcount()));
                }
                for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                    myTxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                    if (myTxxidRecovered == null || myTxxidRecovered.getRecoveraction() == 0 || myTxxidRecovered.getRecoveraction() == 1) continue;
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"possibleheuristic");
                    }
                    possibleheuristic = true;
                }
                if (possibleheuristic) continue;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"write howlDonelog");
                }
                myxacommittingtx = mytxRecovered.getXACommittingTx();
                byte[] rmDone = new byte[11];
                byte[][] rmDoneRecord = new byte[1][11];
                rmDone = "RR3JOTMDONE".getBytes();
                try {
                    rmDoneRecord[0] = rmDone;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(rmDoneRecord, myxacommittingtx);
                }
                catch (Exception f) {
                    String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                    if (!TraceTm.recovery.isDebugEnabled()) break block10;
                    TraceTm.jotm.debug((Object)("Got LogException from howlDoneLog: " + howlerror));
                }
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"remove txRecovered entry");
            }
            vTxRecovered.remove(i);
        }
    }

    static final void byteToHex(byte inbyte, StringBuffer str_buff) {
        int myByte = 0xFF & inbyte;
        str_buff.append(HexDigits[myByte]);
    }
}

