/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Field;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;

public class CheckInjectionPointUsage
extends ValidationBase {
    @Override
    public void validate(EjbModule ejbModule) {
        if (ejbModule.getBeans() == null) {
            return;
        }
        for (Field field : ejbModule.getFinder().findAnnotatedFields(Inject.class)) {
            if (!field.getType().equals(InjectionPoint.class) || !HttpServlet.class.isAssignableFrom(field.getDeclaringClass())) continue;
            this.fail(field.getDeclaringClass().getSimpleName(), "cdi.injectionPointOnNonBean", field.getDeclaringClass().getName(), field.getName());
        }
    }
}

