/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.ConfigProperty;
import org.apache.openejb.jee.InboundResourceadapter;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.ResourceAdapter10;
import org.apache.openejb.jee.SecurityPermission;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="resourceadapterType", propOrder={"resourceAdapterClass", "configProperty", "outboundResourceAdapter", "inboundResourceAdapter", "adminObject", "securityPermission"})
public class ResourceAdapter {
    @XmlElement(name="resourceadapter-class")
    protected String resourceAdapterClass;
    @XmlElement(name="config-property")
    protected List<ConfigProperty> configProperty;
    @XmlElement(name="outbound-resourceadapter")
    protected OutboundResourceAdapter outboundResourceAdapter;
    @XmlElement(name="inbound-resourceadapter")
    protected InboundResourceadapter inboundResourceAdapter;
    @XmlElement(name="adminobject")
    protected List<AdminObject> adminObject;
    @XmlElement(name="security-permission")
    protected List<SecurityPermission> securityPermission;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public ResourceAdapter() {
    }

    public ResourceAdapter(String resourceAdapterClass) {
        this.resourceAdapterClass = resourceAdapterClass;
    }

    public ResourceAdapter(Class resourceAdapterClass) {
        this(resourceAdapterClass.getName());
    }

    public static ResourceAdapter newResourceAdapter(ResourceAdapter10 source) {
        ResourceAdapter resourceAdapter = new ResourceAdapter();
        resourceAdapter.getSecurityPermission().addAll(source.getSecurityPermission());
        resourceAdapter.setId(source.getId());
        OutboundResourceAdapter outboundResourceAdapter = new OutboundResourceAdapter();
        outboundResourceAdapter.getAuthenticationMechanism().addAll(source.getAuthenticationMechanism());
        outboundResourceAdapter.setTransactionSupport(source.getTransactionSupport());
        outboundResourceAdapter.setReauthenticationSupport(source.isReauthenticationSupport());
        outboundResourceAdapter.getConnectionDefinition().add(source.getConnectionDefinition());
        resourceAdapter.setOutboundResourceAdapter(outboundResourceAdapter);
        return resourceAdapter;
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void setResourceAdapterClass(String value) {
        this.resourceAdapterClass = value;
    }

    public List<ConfigProperty> getConfigProperty() {
        if (this.configProperty == null) {
            this.configProperty = new ArrayList<ConfigProperty>();
        }
        return this.configProperty;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this.outboundResourceAdapter;
    }

    public OutboundResourceAdapter setOutboundResourceAdapter(OutboundResourceAdapter value) {
        this.outboundResourceAdapter = value;
        return this.outboundResourceAdapter;
    }

    public InboundResourceadapter getInboundResourceAdapter() {
        return this.inboundResourceAdapter;
    }

    public InboundResourceadapter setInboundResourceAdapter(InboundResourceadapter value) {
        this.inboundResourceAdapter = value;
        return this.inboundResourceAdapter;
    }

    public List<AdminObject> getAdminObject() {
        if (this.adminObject == null) {
            this.adminObject = new ArrayList<AdminObject>();
        }
        return this.adminObject;
    }

    public List<SecurityPermission> getSecurityPermission() {
        if (this.securityPermission == null) {
            this.securityPermission = new ArrayList<SecurityPermission>();
        }
        return this.securityPermission;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }
}

