/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.filewrite;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.vorto.codegen.ui.filewrite.AbstractFileWriteStrategy;
import org.eclipse.vorto.codegen.ui.filewrite.FileWriteContext;
import org.eclipse.vorto.codegen.ui.filewrite.IFileRegion;
import org.eclipse.vorto.codegen.ui.filewrite.IRegionMarker;
import org.eclipse.vorto.codegen.ui.filewrite.RegionMarkerFactory;

public class RegionMergeStrategy
extends AbstractFileWriteStrategy {
    private IFileRegion fileRegion = null;

    public RegionMergeStrategy(IFileRegion fileRegion) {
        this.fileRegion = fileRegion;
    }

    @Override
    public void writeFile(FileWriteContext context, IFile existingFile) throws CoreException, IOException {
        if (!existingFile.exists()) {
            throw new IllegalStateException("No existing file to merge with.");
        }
        String existingContent = this.toString(existingFile.getContents());
        IRegionMarker location = RegionMarkerFactory.getRegionMarker(context.getGenerationKey(), existingContent);
        String mergedContent = this.fileRegion.merge(context.getContent(), existingContent, location);
        if (!mergedContent.equals(existingContent)) {
            existingFile.setContents(this.toInputStream(mergedContent), true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private InputStream toInputStream(String s) {
        return IOUtils.toInputStream((String)s);
    }

    private String toString(InputStream s) throws IOException {
        return IOUtils.toString((InputStream)s);
    }
}

