/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.handler;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IGeneratorLookup;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.handler.CodeGenerationHelper;
import org.eclipse.vorto.codegen.ui.handler.GeneratorLookupLocal;
import org.eclipse.vorto.codegen.ui.progressmonitor.VortoCodeGenProgressMonitorFactory;
import org.eclipse.vorto.codegen.ui.progressmonitor.VortoProgressMonitor;
import org.eclipse.vorto.codegen.ui.utils.PlatformUtils;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelProjectFactory;

public class CodeGeneratorInvocationHandler
extends AbstractHandler {
    private static final IGeneratorLookup lookupService = new GeneratorLookupLocal();

    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String generatorServiceKey = event.getParameter("org.eclipse.vorto.codegen.generator.commandParameter");
        if (this.evaluate(generatorServiceKey)) {
            PlatformUtils.switchPerspective("org.eclipse.jdt.ui.JavaPerspective");
        }
        return null;
    }

    private boolean evaluate(String generatorServiceKey) {
        IModelElement selectedElement = ModelProjectFactory.getInstance().getModelElementFromSelection();
        if (selectedElement == null) {
            MessageDisplayFactory.getMessageDisplay().displayWarning("Model was not properly selected. Please try again.");
            return false;
        }
        if (!this.hasNoErrors(selectedElement)) {
            MessageDisplayFactory.getMessageDisplay().displayError("Model has errors. Cannot generate.");
            return false;
        }
        InformationModel informationModel = this.getInformationModel(selectedElement.getModel());
        try {
            IVortoCodeGenerator generator = lookupService.lookupByKey(generatorServiceKey);
            IGenerationResult result = generator.generate(informationModel, this.createInvocationContext(selectedElement.getProject(), generator.getServiceKey()), VortoCodeGenProgressMonitorFactory.getCodeGenStatusReporter());
            CodeGenerationHelper.createEclipseProject(ModelIdFactory.newInstance((Model)informationModel), generator.getServiceKey(), result);
            VortoProgressMonitor.getDefault().display();
        }
        catch (Exception e) {
            MessageDisplayFactory.getMessageDisplay().displayError((Throwable)e);
        }
        return true;
    }

    private InformationModel getInformationModel(Model model) {
        if (model instanceof InformationModel) {
            return (InformationModel)model;
        }
        if (model instanceof FunctionblockModel) {
            return Utils.wrapFunctionBlock((FunctionblockModel)((FunctionblockModel)model));
        }
        throw new IllegalArgumentException("Cannot generate from selected model");
    }

    private boolean hasNoErrors(IModelElement selectedElement) {
        return selectedElement.getDiagnostics().size() <= 0 && this.noLinkingErrors(selectedElement);
    }

    private boolean noLinkingErrors(IModelElement modelElement) {
        Model model = modelElement.getModel();
        if (model instanceof InformationModel) {
            InformationModel infoModel = (InformationModel)model;
            for (FunctionblockProperty property : infoModel.getProperties()) {
                if (property.getType() != null && property.getType().eResource() != null && property.getType().eResource().getErrors() != null && property.getType().eResource().getErrors().size() > 0) {
                    return false;
                }
                if (this.getLinkingErrors((EObject)property.getType()).size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<Diagnostic> getLinkingErrors(EObject model) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(model);
        switch (diagnostic.getSeverity()) {
            case 4: {
                return diagnostic.getChildren();
            }
        }
        return Collections.emptyList();
    }

    private InvocationContext createInvocationContext(IModelProject project, String targetPlatform) {
        return new InvocationContext(project.getMapping(targetPlatform), lookupService, Collections.emptyMap());
    }
}

