/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.vorto.dnd.dropvalidation;

import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.dnd.dropvalidator.TargetClassSourceClassValidator;

public class DatatypeValidator
extends TargetClassSourceClassValidator {
    public DatatypeValidator(Class<?> targetClass, Class<?> sourceClass) {
        super(targetClass, sourceClass);
    }

    public boolean allow(Object receivingModelElement, Object droppedObject) {
        if (receivingModelElement instanceof IModelElement && droppedObject instanceof IModelElement) {
            boolean entityDroppedToEnum = this.entityDroppedToEnum(((IModelElement)receivingModelElement).getModel(), ((IModelElement)droppedObject).getModel());
            boolean enumDroppedToEnum = this.enumDroppedToEnum(((IModelElement)receivingModelElement).getModel(), ((IModelElement)droppedObject).getModel());
            if (entityDroppedToEnum || enumDroppedToEnum) {
                MessageDisplayFactory.getMessageDisplay().displayError("You cannot drop an Entity or Enum into an Enum");
            }
            return super.allow(receivingModelElement, droppedObject) && !entityDroppedToEnum && !enumDroppedToEnum;
        }
        return false;
    }

    private boolean entityDroppedToEnum(Model targetModel, Model droppedModel) {
        return targetModel instanceof Enum && droppedModel instanceof Entity;
    }

    private boolean enumDroppedToEnum(Model targetModel, Model droppedModel) {
        return targetModel instanceof Enum && droppedModel instanceof Enum;
    }
}

