/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.adapters.IPersistenceFileModelAdapter;
import org.eclipse.dali.orm.adapters.xml.XMLPersistentTypeModelAdapter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NodeList;

public class XMLPersistenceFileModelAdapter
implements IPersistenceFileModelAdapter {
    private PersistenceFile persistenceFile;
    private IDOMModel domModel;
    private Collection persistentTypeModelAdapters = new ArrayList();
    private IModelStateListener modelStateListener = this.buildModelStateListener();

    public void setPersistenceFile(PersistenceFile persistenceFile) {
        this.persistenceFile = persistenceFile;
    }

    private IModelStateListener buildModelStateListener() {
        return new IModelStateListener(){

            public void modelReinitialized(IStructuredModel structuredModel) {
            }

            public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            }

            public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            }

            public void modelResourceDeleted(IStructuredModel model) {
            }

            public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            }

            public void modelChanged(IStructuredModel model) {
                Iterator stream = XMLPersistenceFileModelAdapter.this.persistentTypeModelAdapters.iterator();
                while (stream.hasNext()) {
                    XMLPersistentTypeModelAdapter adapter = (XMLPersistentTypeModelAdapter)stream.next();
                    adapter.modelChanged(model);
                }
            }

            public void modelAboutToBeChanged(IStructuredModel model) {
            }
        };
    }

    public void engage() {
        this.updateModel();
        this.hookModelStateListener();
    }

    public void disengage() {
        Iterator i = this.persistentTypeModelAdapters.iterator();
        while (i.hasNext()) {
            ((XMLPersistentTypeModelAdapter)i.next()).disengage();
        }
        this.persistentTypeModelAdapters = null;
        this.unhookModelStateListener();
        this.persistenceFile = null;
    }

    public void handleEvent(ElementChangedEvent event) {
    }

    private void hookModelStateListener() {
        this.domModel.addModelStateListener(this.modelStateListener);
    }

    private void unhookModelStateListener() {
        this.domModel.removeModelStateListener(this.modelStateListener);
    }

    private void updateModel() {
        this.updatePersistentTypes();
    }

    private IDOMDocument getDomDocument() {
        return this.domModel.getDocument();
    }

    private void updatePersistentTypes() {
        NodeList entities = this.getDomDocument().getElementsByTagName("p:entity");
        int i = 0;
        while (i < entities.getLength()) {
            IDOMElement entity = (IDOMElement)entities.item(i);
            this.addPersistentType(entity);
            ++i;
        }
    }

    private void addPersistentType(IDOMElement entity) {
        XMLPersistentTypeModelAdapter persistentTypeModelAdapter = new XMLPersistentTypeModelAdapter(entity);
        PersistentType persistentType = OrmFactory.eINSTANCE.createPersistentType(persistentTypeModelAdapter);
        this.persistenceFile.getPersistentTypes().add((Object)persistentType);
        persistentTypeModelAdapter.engage(persistentType);
        this.persistentTypeModelAdapters.add(persistentTypeModelAdapter);
    }

    public ITextRange getTextRange() {
        return null;
    }
}

