/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.Alerts;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends AbstractUIPlugin {
    private static final String PROPERTIES = "default.properties";
    private static boolean TWO_DOT_ONE;
    private static boolean THREE_DOT;
    private static String version;
    private static CommonPlugin plugin;
    private Logger log;
    private ResourceBundle resourceBundle;
    private Properties properties;
    private URL pluginBase;
    private static Alerts alerts;

    public CommonPlugin() {
        plugin = this;
        this.versionCheck();
    }

    private void versionCheck() {
        String version = (String)ResourcesPlugin.getPlugin().getBundle().getHeaders().get("Bundle-Version");
        PluginVersionIdentifier identifier = new PluginVersionIdentifier(version);
        TWO_DOT_ONE = identifier.getMajorComponent() == 2 && identifier.getMinorComponent() == 1;
        THREE_DOT = identifier.getMajorComponent() == 3;
        CommonPlugin.version = identifier.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!CommonPlugin.isThreeDot()) {
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Requires eclipse version 3.x", null));
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.wtp.jsf.facesconfig.editor.common.CommonResources");
            alerts = new Alerts(this, this.resourceBundle);
            this.properties = new Properties();
            InputStream input = null;
            this.pluginBase = this.getBundle().getEntry("/");
            try {
                input = new URL(this.pluginBase, PROPERTIES).openStream();
                this.properties.load(input);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            try {}
            catch (IOException iOException) {}
            input.close();
            this.log = new Logger(this.getBundle(), this.resourceBundle);
            this.log.info("log.CommonPlugin", version);
            return;
        }
        catch (Exception ee) {
            if (this.log == null) throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Web Application Development Common", (Throwable)ee));
            this.log.error("log.msg", "Problems starting plug-in Web Application Development Common.", ee);
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Web Application Development Common", (Throwable)ee));
        }
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public static Alerts getAlerts() {
        return alerts;
    }

    public static Logger getLogger(Class theClass) {
        return CommonPlugin.getDefault().getRootLogger();
    }

    public Logger getRootLogger() {
        return this.log;
    }

    public static String getPluginId() {
        return CommonPlugin.getDefault().getBundle().getSymbolicName();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getPluginDecriptorBundle() {
        return Platform.getResourceBundle((Bundle)CommonPlugin.getDefault().getBundle());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public Image getImage(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        Image image = images.get(name);
        if (image == null) {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(this.pluginBase, "icons/" + name));
                images.put(name, id);
                image = images.get(name);
            }
            catch (MalformedURLException ee) {
                this.log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        ImageDescriptor id = images.getDescriptor(name);
        if (id == null) {
            try {
                id = ImageDescriptor.createFromURL((URL)new URL(this.pluginBase, "icons/" + name));
                images.put(name, id);
            }
            catch (MalformedURLException ee) {
                this.log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return id;
    }

    public InputStream readFile(String file) throws MalformedURLException, IOException {
        return new URL(this.pluginBase, file).openStream();
    }

    public static boolean isTwoDotOne() {
        return TWO_DOT_ONE;
    }

    public static boolean isThreeDot() {
        return THREE_DOT;
    }

    public static String getVersion() {
        return version;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (CommonPlugin.getDefault().getWorkbench() == null) {
            return null;
        }
        return CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CommonPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }
}

