/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.PageflowLayoutManager;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowValidation;

public class ConnectionCommand
extends Command {
    protected PageflowNode oldSource;
    protected PageflowNode oldTarget;
    protected PageflowNode pageflowNode;
    protected PageflowNode target;
    protected PFLink link;

    public ConnectionCommand() {
        super(EditorResources.getInstance().getString("Pageflow.Commands.ConnectionCommand.Label"));
    }

    public boolean canExecute() {
        if (this.link == null) {
            return false;
        }
        if (this.oldSource == null && this.oldTarget == null) {
            if (this.pageflowNode == null || this.target == null) {
                return false;
            }
            if (!PageflowValidation.getInstance().isValidLinkForCreation(this.pageflowNode, this.target)) {
                return false;
            }
        }
        if (this.oldSource != null && this.pageflowNode != null && this.oldTarget != null && this.target != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.pageflowNode, this.target)) {
            return false;
        }
        if (this.oldSource != null && this.pageflowNode != null && !PageflowValidation.getInstance().isValidLinkForCreation(this.pageflowNode, this.oldTarget)) {
            return false;
        }
        return this.oldTarget == null || this.target == null || PageflowValidation.getInstance().isValidLinkForCreation(this.oldSource, this.target);
    }

    public void execute() {
        if (this.pageflowNode == null && this.target == null) {
            this.oldSource.getOutlinks().remove((Object)this.link);
            this.oldTarget.getInlinks().remove((Object)this.link);
            this.oldSource.getPageflow().getLinks().remove((Object)this.link);
        }
        if (this.oldSource != null && this.pageflowNode != null) {
            if (this.link.getSource() != null) {
                this.link.getSource().getOutlinks().remove((Object)this.link);
            }
            this.link.setSource(this.pageflowNode);
            this.pageflowNode.getOutlinks().add((Object)this.link);
        }
        if (this.oldTarget != null && this.target != null) {
            if (this.link.getTarget() != null) {
                this.link.getTarget().getInlinks().remove((Object)this.link);
            }
            this.link.setTarget(this.target);
            this.target.getInlinks().add((Object)this.link);
        }
        if (this.oldSource == null && this.oldTarget == null) {
            Pageflow pageflow = null;
            if (this.pageflowNode != null) {
                pageflow = this.pageflowNode.getPageflow();
            } else if (this.target != null) {
                pageflow = this.target.getPageflow();
            }
            pageflow.connect(this.pageflowNode, this.target, this.link);
            if (this.pageflowNode == this.target) {
                PageflowLayoutManager.updateSelfLoopLink(this.link);
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (this.link == null) {
            return;
        }
        if (this.pageflowNode == null && this.target == null) {
            this.oldSource.getOutlinks().add((Object)this.link);
            this.oldTarget.getInlinks().add((Object)this.link);
            this.oldSource.getPageflow().getLinks().add((Object)this.link);
        }
        if (this.oldSource != null && this.pageflowNode != null) {
            if (this.link.getSource() != null) {
                this.link.getSource().getOutlinks().remove((Object)this.link);
            }
            this.pageflowNode.getOutlinks().remove((Object)this.link);
            this.link.setSource(this.oldSource);
            this.oldSource.getOutlinks().add((Object)this.link);
        }
        if (this.oldTarget != null && this.target != null) {
            if (this.link.getTarget() != null) {
                this.link.getTarget().getInlinks().remove((Object)this.link);
            }
            this.target.getInlinks().remove((Object)this.link);
            this.link.setTarget(this.oldTarget);
            this.oldTarget.getInlinks().add((Object)this.link);
        }
        if (this.oldSource == null && this.oldTarget == null) {
            Pageflow pageflow = null;
            if (this.pageflowNode != null) {
                pageflow = this.pageflowNode.getPageflow();
            } else if (this.target != null) {
                pageflow = this.target.getPageflow();
            }
            this.pageflowNode.getOutlinks().remove((Object)this.link);
            this.target.getInlinks().remove((Object)this.link);
            this.link.setSource(null);
            this.link.setTarget(null);
            pageflow.getLinks().remove((Object)this.link);
        }
    }

    public PageflowNode getSource() {
        return this.pageflowNode;
    }

    public PageflowNode getTarget() {
        return this.target;
    }

    public PFLink getPFLink() {
        return this.link;
    }

    public void setSource(PageflowNode newSource) {
        this.pageflowNode = newSource;
    }

    public void setTarget(PageflowNode newTarget) {
        this.target = newTarget;
    }

    public void setPFLink(PFLink link) {
        this.link = link;
        this.oldSource = link.getSource();
        this.oldTarget = link.getTarget();
    }
}

