/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.model.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ListEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedProperty;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.MapEntriesRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JavaBeanUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JavaClassUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.JavaBeanProperty;

public class ManagedPropertyRecorder {
    private String valueType = "value";
    private ListEntriesRecorder listEntries;
    private MapEntriesRecorder mapEntries;
    private List classProperties;
    private String value = "";
    private String propertyClass = "";
    private String propertyName = "";
    private ManagedProperty property;
    private ManagedBean bean;

    public ManagedPropertyRecorder(ManagedProperty property, ManagedBean bean) {
        this.property = property;
        this.bean = bean;
        this.retrieveBeanProperty(bean);
        this.retrieveProperty(property);
    }

    public ManagedBean getBean() {
        return this.bean;
    }

    public void setBean(ManagedBean mbean) {
        this.bean = mbean;
        this.getListEntries().setBean(mbean);
        this.getMapEntries().setBean(mbean);
    }

    public ManagedProperty getProperty() {
        return this.property;
    }

    public List getClassProperties() {
        if (this.classProperties == null) {
            this.classProperties = new ArrayList();
        }
        return this.classProperties;
    }

    private void retrieveBeanProperty(ManagedBean bean) {
        if (bean == null) {
            return;
        }
        String beanClassName = bean.getElement().getChildNodeValue("managed-bean-class");
        if (beanClassName.length() == 0) {
            return;
        }
        IType classType = JavaClassUtils.getType(StructuredModelUtil.getProjectFor(bean.getNode()), beanClassName);
        if (classType == null) {
            return;
        }
        JavaBeanProperty[] properties = JavaBeanUtils.getBeanProperties(classType);
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                if (!this.existedProperty(properties[i].getName())) {
                    ClassProperty property = new ClassProperty();
                    property._propertyName = properties[i].getName();
                    property._propertyClass = properties[i].getQualifiedType();
                    this.getClassProperties().add(property);
                }
                ++i;
            }
        }
    }

    private boolean existedProperty(String propertyName) {
        Iterator iter = this.getBean().getManagedPropertyList().iterator();
        while (iter.hasNext()) {
            ManagedProperty property = (ManagedProperty)iter.next();
            if (!property.getPropertyName().trim().equals(propertyName.trim())) continue;
            return true;
        }
        return false;
    }

    private void retrieveProperty(ManagedProperty property) {
        if (property == null) {
            return;
        }
        this.valueType = property.getPropertyValueType();
        if (!this.valueType.equalsIgnoreCase("null-value")) {
            if (this.valueType.equalsIgnoreCase("value")) {
                this.value = property.getPropertyValue();
            } else if (this.valueType.equalsIgnoreCase("map-entries")) {
                this.retrieveMapEntries(property);
            } else if (this.valueType.equalsIgnoreCase("list-entries")) {
                this.retrieveListEntries(property);
            }
        }
        this.propertyName = property.getPropertyName();
        this.propertyClass = property.getPropertyClass();
    }

    private void retrieveMapEntries(ManagedProperty property) {
        this.mapEntries = new MapEntriesRecorder(property.getNode(), this.getBean());
        this.mapEntries.retrieve();
    }

    private void retrieveListEntries(ManagedProperty property) {
        this.listEntries = new ListEntriesRecorder(property.getNode(), this.getBean());
        this.listEntries.retrieve();
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public void setPropertyClass(String className) {
        this.propertyClass = className;
    }

    public void update() {
        if (this.property == null) {
            this.property = new ManagedProperty(this.getBean().getElement().createChildNode("managed-property", true, null, FacesConfigOrderHelper.getInstance()));
        }
        if (this.property.getElement().getChildNode("property-name") != null) {
            this.property.getElement().setChildNodeValue("property-name", this.getPropertyName());
        } else {
            this.property.getElement().createChildNode("property-name", false, this.getPropertyName(), FacesConfigOrderHelper.getInstance());
        }
        if (this.property.getElement().getChildNode("property-class") != null) {
            this.property.getElement().setChildNodeValue("property-class", this.getPropertyClass());
        } else {
            this.property.getElement().createChildNode("property-class", false, this.getPropertyClass(), FacesConfigOrderHelper.getInstance());
        }
        if (this.getValueType().equalsIgnoreCase("value")) {
            this.property.getElement().removeChildNodes("null-value");
            this.property.getElement().removeChildNodes("map-entries");
            this.property.getElement().removeChildNodes("list-entries");
            if (this.property.getElement().getChildNode("value") != null) {
                this.property.getElement().setChildNodeValue("value", this.getValue());
            } else {
                this.property.getElement().createChildNode("value", false, this.getValue(), FacesConfigOrderHelper.getInstance());
            }
        } else if (this.getValueType().equalsIgnoreCase("null-value")) {
            this.property.getElement().removeChildNodes("value");
            this.property.getElement().removeChildNodes("map-entries");
            this.property.getElement().removeChildNodes("list-entries");
            if (this.property.getElement().getChildNode("null-value") == null) {
                this.property.getElement().createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance());
            }
        } else if (this.getValueType().equalsIgnoreCase("map-entries")) {
            this.property.getElement().removeChildNodes("value");
            this.property.getElement().removeChildNodes("null-value");
            this.property.getElement().removeChildNodes("list-entries");
            this.updateMapEntries();
        } else if (this.getValueType().equalsIgnoreCase("list-entries")) {
            this.property.getElement().removeChildNodes("value");
            this.property.getElement().removeChildNodes("null-value");
            this.property.getElement().removeChildNodes("map-entries");
            this.updateListEntries();
        }
    }

    private void updateMapEntries() {
        if (this.getProperty() != null) {
            this.getMapEntries().setParentNode(this.getProperty().getNode());
            this.getMapEntries().update();
        }
    }

    private void updateListEntries() {
        if (this.getProperty() != null) {
            this.getListEntries().setParentNode(this.getProperty().getNode());
            this.getListEntries().update();
        }
    }

    public MapEntriesRecorder getMapEntries() {
        if (this.mapEntries == null) {
            this.mapEntries = this.getProperty() != null ? new MapEntriesRecorder(this.getProperty().getNode(), this.getBean()) : new MapEntriesRecorder(null, this.getBean());
        }
        return this.mapEntries;
    }

    public ListEntriesRecorder getListEntries() {
        if (this.listEntries == null) {
            this.listEntries = this.getProperty() != null ? new ListEntriesRecorder(this.getProperty().getNode(), this.getBean()) : new ListEntriesRecorder(null, this.getBean());
        }
        return this.listEntries;
    }

    public void setMapEntries(MapEntriesRecorder mapEntries) {
        this.mapEntries = mapEntries;
    }

    public void setListEntries(ListEntriesRecorder listEntries) {
        this.listEntries = listEntries;
    }

    public class ClassProperty {
        public String _propertyName;
        public String _propertyClass;
        public boolean existedInFacesConfig = false;
    }
}

