/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.model.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.w3c.dom.Node;

public class MapEntriesRecorder {
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;
    private String keyClass;
    private String valueClass;
    private List mapEntries;
    private IDOMNode parentNode;
    private ManagedBean bean;
    private boolean bSynchronizeWithModel;

    public MapEntriesRecorder(IDOMNode parentNode, ManagedBean bean) {
        this.parentNode = parentNode;
        this.bean = bean;
        this.bSynchronizeWithModel = false;
    }

    public void setSynchronzeWithModel(boolean bSynchronize) {
        this.bSynchronizeWithModel = bSynchronize;
    }

    public void retrieve() {
        if (this.parentNode == null || this.bean == null) {
            return;
        }
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        IDOMNode mapEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("map-entries");
        if (mapEntriesNode != null) {
            NodeWrapUtil mapEntriesWrap = new NodeWrapUtil(mapEntriesNode);
            this.keyClass = mapEntriesWrap.getChildNodeValue("key-class");
            this.valueClass = mapEntriesWrap.getChildNodeValue("value-class");
            if (mapEntriesWrap.getChildNodes("map-entry") != null) {
                Iterator iter = mapEntriesWrap.getChildNodes("map-entry").iterator();
                while (iter.hasNext()) {
                    this.addMapEntry((IDOMNode)iter.next());
                }
            }
        }
    }

    public void update() {
        if (this.parentNode == null || this.bean == null) {
            return;
        }
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        parentNodeWrap.removeChildNodes("map-entries");
        IDOMNode mapEntriesNode = parentNodeWrap.createChildNode("map-entries", true, null, FacesConfigOrderHelper.getInstance());
        NodeWrapUtil mapEntriesNodeWrap = new NodeWrapUtil(mapEntriesNode);
        if (this.getKeyClass() != null && this.getKeyClass().length() > 0) {
            mapEntriesNodeWrap.createChildNode("key-class", false, this.getKeyClass(), FacesConfigOrderHelper.getInstance());
        }
        if (this.getValueClass() != null && this.getValueClass().length() > 0) {
            mapEntriesNodeWrap.createChildNode("value-class", false, this.getValueClass(), FacesConfigOrderHelper.getInstance());
        }
        Iterator iter = this.getMapEntries().iterator();
        while (iter.hasNext()) {
            MapEntry mapEntry = (MapEntry)iter.next();
            NodeWrapUtil mapEntryNodeWrap = new NodeWrapUtil(mapEntriesNodeWrap.createChildNode("map-entry", true, null, FacesConfigOrderHelper.getInstance()));
            mapEntryNodeWrap.createChildNode("key", false, mapEntry._key, FacesConfigOrderHelper.getInstance());
            if (mapEntry._valueType.equalsIgnoreCase("null-value")) {
                mapEntryNodeWrap.createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance());
                continue;
            }
            mapEntryNodeWrap.createChildNode("value", false, mapEntry._value, FacesConfigOrderHelper.getInstance());
        }
    }

    public void setParentNode(IDOMNode parentNode) {
        this.parentNode = parentNode;
    }

    public IDOMNode getParentNode() {
        return this.parentNode;
    }

    public void setBean(ManagedBean bean) {
        this.bean = bean;
    }

    public ManagedBean getBean() {
        return this.bean;
    }

    public void setKeyClass(String keyClass) {
        this.keyClass = keyClass;
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil mapEntriesNodeWrap;
            IDOMNode keyClassNode;
            NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
            IDOMNode mapEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("map-entries");
            if (mapEntriesNode == null) {
                mapEntriesNode = parentNodeWrap.createChildNode("map-entries", true, null, FacesConfigOrderHelper.getInstance());
            }
            if ((keyClassNode = (IDOMNode)(mapEntriesNodeWrap = new NodeWrapUtil(mapEntriesNode)).getChildNode("key-class")) == null) {
                mapEntriesNodeWrap.createChildNode("key-class", true, null, FacesConfigOrderHelper.getInstance());
            }
            mapEntriesNodeWrap.setChildNodeValueKeepEmpty("key-class", this.keyClass);
        }
    }

    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil mapEntriesNodeWrap;
            IDOMNode valueClassNode;
            NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
            IDOMNode mapEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("map-entries");
            if (mapEntriesNode == null) {
                mapEntriesNode = parentNodeWrap.createChildNode("map-entries", true, null, FacesConfigOrderHelper.getInstance());
            }
            if ((valueClassNode = (IDOMNode)(mapEntriesNodeWrap = new NodeWrapUtil(mapEntriesNode)).getChildNode("value-class")) == null) {
                mapEntriesNodeWrap.createChildNode("value-class", true, null, FacesConfigOrderHelper.getInstance());
            }
            mapEntriesNodeWrap.setChildNodeValueKeepEmpty("value-class", this.valueClass);
        }
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setMapEntries(List mapEntries) {
        if (this.mapEntries != null) {
            this.mapEntries.clear();
        }
        if (this.mapEntries == null) {
            this.mapEntries = new ArrayList();
        }
        this.mapEntries.addAll(mapEntries);
    }

    public List getMapEntries() {
        if (this.mapEntries == null) {
            this.mapEntries = new ArrayList();
        }
        return this.mapEntries;
    }

    public void moveMapEntry(MapEntry entry, int direction) {
    }

    public boolean isEmpty() {
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        return parentNodeWrap.getChildNode("map-entries") == null;
    }

    public void clearAll() {
        this.keyClass = "";
        this.valueClass = "";
        this.getMapEntries().clear();
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        parentNodeWrap.removeChildNodes("map-entries");
    }

    public void removeMapEntry(MapEntry entry) {
        this.getMapEntries().remove(entry);
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil.removeNode((Node)entry._node);
        }
    }

    public MapEntry addMapEntry(IDOMNode mapEntry) {
        MapEntry entry = null;
        NodeWrapUtil mapEntryWrap = new NodeWrapUtil(mapEntry);
        entry = mapEntryWrap.getChildNode("null-value") != null ? this.addMapEntryToList(mapEntryWrap.getChildNodeValue("key"), "null-value", null) : this.addMapEntryToList(mapEntryWrap.getChildNodeValue("key"), "value", mapEntryWrap.getChildNodeValue("value"));
        if (entry != null) {
            entry._node = mapEntry;
        }
        return entry;
    }

    private MapEntry addMapEntryToList(String key, String valueType, String value) {
        MapEntry entry = null;
        if (valueType.equalsIgnoreCase("null-value") || valueType.equalsIgnoreCase("value")) {
            entry = new MapEntry();
            entry._valueType = valueType;
            entry._key = key;
            entry._value = value;
            this.getMapEntries().add(entry);
        }
        return entry;
    }

    private MapEntry addMapEntryToModel(String key, String valueType, String value) {
        MapEntry entry = null;
        if (valueType.equalsIgnoreCase("null-value") || valueType.equalsIgnoreCase("value")) {
            entry = new MapEntry();
            entry._valueType = valueType;
            entry._key = key;
            entry._value = value;
            NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
            IDOMNode mapEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("map-entries");
            if (mapEntriesNode == null) {
                mapEntriesNode = parentNodeWrap.createChildNode("map-entries", true, null, FacesConfigOrderHelper.getInstance());
            }
            NodeWrapUtil mapEntriesNodeWrap = new NodeWrapUtil(mapEntriesNode);
            IDOMNode mapEntryNode = mapEntriesNodeWrap.createChildNode("map-entry", true, null, FacesConfigOrderHelper.getInstance());
            NodeWrapUtil mapEntryNodeWrap = new NodeWrapUtil(mapEntryNode);
            mapEntryNodeWrap.createChildNode("key", false, entry._key, FacesConfigOrderHelper.getInstance());
            if (entry._valueType.equalsIgnoreCase("null-value")) {
                mapEntryNodeWrap.createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance());
            } else {
                mapEntryNodeWrap.createChildNode("value", false, entry._value, FacesConfigOrderHelper.getInstance());
            }
            entry._node = mapEntryNode;
        }
        return entry;
    }

    public MapEntry addMapEntry(String key, String valueType, String value) {
        if (this.bSynchronizeWithModel) {
            return this.addMapEntryToModel(key, valueType, value);
        }
        return this.addMapEntryToList(key, valueType, value);
    }

    public void updateMapEntry(MapEntry mapEntry, String key, String valueType, String value) {
        mapEntry._key = key;
        mapEntry._valueType = valueType;
        mapEntry._value = value;
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil mapEntryNodeWrap = new NodeWrapUtil(mapEntry._node);
            mapEntryNodeWrap.removeChildNodes("key");
            mapEntryNodeWrap.removeChildNodes("null-value");
            mapEntryNodeWrap.removeChildNodes("value");
            mapEntryNodeWrap.createChildNode("key", false, mapEntry._key, FacesConfigOrderHelper.getInstance());
            if (mapEntry._valueType.equalsIgnoreCase("null-value")) {
                mapEntryNodeWrap.createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance());
            } else {
                mapEntryNodeWrap.createChildNode("value", false, mapEntry._value, FacesConfigOrderHelper.getInstance());
            }
        }
    }

    public void updateMapEntry(MapEntry mapEntry, IDOMNode node) {
        NodeWrapUtil mapEntryWrap = new NodeWrapUtil(node);
        mapEntry._key = mapEntryWrap.getChildNodeValue("key");
        if (mapEntryWrap.getChildNode("null-value") != null) {
            mapEntry._valueType = "null-value";
        } else {
            mapEntry._valueType = "value";
            mapEntry._value = mapEntryWrap.getChildNodeValue("value");
        }
        mapEntry._node = node;
    }

    public String toString() {
        String strMapEntries = "";
        strMapEntries = "[map-entries]";
        return strMapEntries;
    }

    public class MapEntry {
        public String _key;
        public String _valueType = "value";
        public String _value;
        public IDOMNode _node = null;
    }
}

